/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFile
implements JavaFileObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualFile.class);
    private final Map<String, VirtualFile> files;
    private final String name;
    private byte[] data;
    private VirtualFile parent;
    private URI uri;
    private final Set<VirtualFile> sourceFiles;

    public VirtualFile() {
        this.files = new HashMap<String, VirtualFile>();
        this.data = new byte[0];
        this.sourceFiles = new HashSet<VirtualFile>();
        this.parent = null;
        this.name = null;
    }

    public VirtualFile(VirtualFile parent, String name) {
        block5: {
            this.files = new HashMap<String, VirtualFile>();
            this.data = new byte[0];
            this.sourceFiles = new HashSet<VirtualFile>();
            this.parent = parent;
            this.name = name;
            if (name != null & parent != null) {
                try {
                    if (parent.toUri() != null) {
                        this.uri = new URI(parent.toUri() + "/" + name);
                        break block5;
                    }
                    this.uri = new URI(name.replace("\\", "/"));
                }
                catch (URISyntaxException e) {
                    LOGGER.error("", (Throwable)e);
                }
            } else {
                this.uri = null;
            }
        }
    }

    public VirtualFile(File file) throws IOException {
        this(null, file);
    }

    public VirtualFile(VirtualFile parent, File file) throws IOException {
        this.files = new HashMap<String, VirtualFile>();
        this.data = new byte[0];
        this.sourceFiles = new HashSet<VirtualFile>();
        this.parent = parent;
        this.name = file.getName();
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.files.put(f.getName(), new VirtualFile(this, f));
            }
        } else {
            this.setData(FileUtils.readFileToByteArray((File)file));
        }
    }

    public VirtualFile createFile(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains(File.separator)) {
            String newName = path.substring(0, path.indexOf(File.separator));
            if (this.files.containsKey(newName)) {
                VirtualFile virtualFile = this.files.get(newName);
                return virtualFile.createFile(path.substring(path.indexOf(File.separator) + 1));
            }
            VirtualFile virtualFile = new VirtualFile(this, newName);
            this.files.put(newName, virtualFile);
            return virtualFile.createFile(path.substring(path.indexOf(File.separator) + 1));
        }
        VirtualFile virtualFile = new VirtualFile(this, path);
        if (path.endsWith(".java")) {
            this.sourceFiles.add(virtualFile);
        }
        this.files.put(path, virtualFile);
        return virtualFile;
    }

    public void setStringContent(String content) {
        this.data = content.getBytes(Charsets.UTF_8);
    }

    @Override
    public OutputStream openOutputStream() {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                super.close();
                VirtualFile.access$002(VirtualFile.this, this.toByteArray());
            }
        };
    }

    public void createJar(OutputStream outputStream) {
        try {
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
            this.createJar(jarOutputStream);
            jarOutputStream.finish();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void dumpToDir(File dir) {
        if (this.isDirectory()) {
            dir.mkdir();
            for (VirtualFile virtualFile : this.files.values()) {
                virtualFile.dumpToDir(new File(dir, virtualFile.name));
            }
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(dir);
                ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
                IOUtils.copy((InputStream)bais, (OutputStream)fos);
                fos.close();
            }
            catch (FileNotFoundException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    private void createJar(JarOutputStream jarOutputStream) throws IOException {
        for (VirtualFile virtualFile : this.files.values()) {
            if (virtualFile.isDirectory()) {
                virtualFile.createJar(jarOutputStream);
                continue;
            }
            JarEntry jarEntry = new JarEntry(virtualFile.getName().replace(File.separator, "/"));
            jarOutputStream.putNextEntry(jarEntry);
            InputStream inputStream = virtualFile.openInputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)jarOutputStream);
            inputStream.close();
        }
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public Collection<VirtualFile> listFiles() {
        return this.files.values();
    }

    public boolean isDirectory() {
        return this.files.size() != 0;
    }

    @Override
    public String getName() {
        if (this.parent != null && this.parent.getName() != null) {
            return this.parent.getName() + "/" + this.name;
        }
        return this.name;
    }

    public List<VirtualFile> getAllJavaFileObjects() {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(this.sourceFiles);
        for (VirtualFile virtualFile : this.files.values()) {
            if (!virtualFile.isDirectory()) continue;
            list.addAll(virtualFile.getAllJavaFileObjects());
        }
        return list;
    }

    @Override
    public Modifier getAccessLevel() {
        return Modifier.PUBLIC;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        if (this.name.endsWith(".java")) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (this.name.endsWith(".class")) {
            return JavaFileObject.Kind.CLASS;
        }
        if (this.name.endsWith(".html")) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public NestingKind getNestingKind() {
        return NestingKind.TOP_LEVEL;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return true;
    }

    @Override
    public boolean delete() {
        return this.parent.remove(this);
    }

    private boolean remove(VirtualFile virtualFile) {
        return this.files.remove(virtualFile.getName()) != null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return new String(this.data, Charsets.UTF_8);
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) {
        return new StringReader(new String(this.data, Charsets.UTF_8));
    }

    @Override
    public Writer openWriter() throws IOException {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                super.close();
                VirtualFile.access$002(VirtualFile.this, this.toString().getBytes(Charsets.UTF_8));
            }
        };
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    public String getPackageName() {
        String name = this.getName();
        return name.replace("/", ".");
    }

    public Collection<VirtualFile> getFiles() {
        return this.files.values();
    }

    public Collection<VirtualFile> getFiles(Set<JavaFileObject.Kind> kinds) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (VirtualFile f : this.files.values()) {
            for (JavaFileObject.Kind kind : kinds) {
                if (!f.name.endsWith(kind.extension.toLowerCase()) || !f.name.endsWith(".class")) continue;
                list.add(f);
            }
        }
        return list;
    }

    public void integrate(VirtualFile baseDir) {
        if (baseDir.isDirectory()) {
            for (VirtualFile file : baseDir.getFiles()) {
                if (this.files.containsKey(file.name)) {
                    if (file.isDirectory()) {
                        this.files.get(file.name).integrate(file);
                        continue;
                    }
                    this.files.get(file.name).add(file);
                    continue;
                }
                this.files.put(file.name, file);
                file.parent = this;
            }
        }
    }

    private void add(VirtualFile file) {
        this.files.put(file.name, file);
    }

    public String toString() {
        return this.uri.toString();
    }

    public Collection<VirtualFile> getFiles(Set<JavaFileObject.Kind> kinds, String path) {
        if (path.contains("/")) {
            String substring = path.substring(0, path.indexOf("/"));
            if (this.files.containsKey(substring)) {
                return this.files.get(substring).getFiles(kinds, path.substring(path.indexOf("/") + 1));
            }
        } else if (this.files.containsKey(path)) {
            return this.files.get(path).getFiles(kinds);
        }
        return new ArrayList<VirtualFile>();
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getCleanName() {
        String name = this.getName();
        if (name.contains(".")) {
            name = name.substring(0, name.indexOf("."));
        }
        return name.replace("/", ".");
    }

    public boolean containsType(String path) {
        if (path.contains("/")) {
            String newName = path.substring(0, path.indexOf("/"));
            if (this.files.containsKey(newName)) {
                return this.files.get(newName).containsType(path.substring(path.indexOf("/") + 1));
            }
            return false;
        }
        return this.files.containsKey(path);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualFile other = (VirtualFile)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public VirtualFile get(String name) {
        return this.files.get(name);
    }

    public VirtualFile getClass(String name) {
        if (name.contains(".")) {
            VirtualFile virtualFile = this.files.get(name.substring(0, name.indexOf(".")));
            if (virtualFile == null) {
                throw new RuntimeException("Not found: " + name);
            }
            return virtualFile.getClass(name.substring(name.indexOf(".") + 1));
        }
        return this.files.get(name + ".class");
    }

    public byte[] getData() {
        return this.data;
    }

    public static VirtualFile fromJar(File file) throws IOException {
        return VirtualFile.fromJar(new FileInputStream(file));
    }

    public static VirtualFile fromJar(InputStream inputStream) throws IOException {
        VirtualFile result = new VirtualFile();
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String n = jarEntry.getName();
            n = n.replace("/", File.separator);
            n = n.replace("\\", File.separator);
            VirtualFile newFile = result.createFile(n);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)jarInputStream, (OutputStream)byteArrayOutputStream);
            newFile.setData(byteArrayOutputStream.toByteArray());
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return result;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void add(File file) {
    }

    public static VirtualFile fromDirectory(File file) throws IOException {
        return new VirtualFile(file);
    }

    public void copyTo(VirtualFile virtualFile) {
    }

    public void setData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)output);
        this.setData(output.toByteArray());
        inputStream.close();
    }

    static /* synthetic */ byte[] access$002(VirtualFile x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }
}

