/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.bimserver.plugins.VirtualFile;

public class VirtualFileManager
implements JavaFileManager {
    private final VirtualFile baseDir;
    private final JavaFileManager fallbackFileManager;
    private final ClassLoader classLoader;

    public VirtualFileManager(JavaFileManager fallbackFileManager, ClassLoader classLoader, VirtualFile baseDir) {
        this.fallbackFileManager = fallbackFileManager;
        this.classLoader = classLoader;
        this.baseDir = baseDir;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        if (a instanceof VirtualFile || b instanceof VirtualFile) {
            return a.toUri().equals(b.toUri());
        }
        return this.fallbackFileManager.isSameFile(a, b);
    }

    @Override
    public void close() throws IOException {
        this.fallbackFileManager.close();
    }

    @Override
    public void flush() throws IOException {
        this.fallbackFileManager.flush();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fallbackFileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fallbackFileManager.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.fallbackFileManager.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        String path = sibling.getName();
        String cleanPath = path;
        if (cleanPath.contains("$")) {
            cleanPath = cleanPath.substring(0, cleanPath.indexOf("$"));
        }
        if (this.baseDir.containsType(cleanPath)) {
            return this.baseDir.createFile(path.replace(".java", "").replace(".", "/") + ".class");
        }
        return null;
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fallbackFileManager.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.fallbackFileManager.hasLocation(location);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof VirtualFile) {
            return ((VirtualFile)file).getCleanName();
        }
        return this.fallbackFileManager.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        final Iterator<VirtualFile> myIterator = this.baseDir.getFiles(kinds, packageName.replace(".", File.separator)).iterator();
        Iterable<JavaFileObject> base = this.fallbackFileManager.list(location, packageName, kinds, recurse);
        if (!myIterator.hasNext()) {
            return base;
        }
        final Iterator<JavaFileObject> baseIterator = base.iterator();
        final Iterator<JavaFileObject> iterator = new Iterator<JavaFileObject>(){

            @Override
            public boolean hasNext() {
                boolean result = baseIterator.hasNext() || myIterator.hasNext();
                return result;
            }

            @Override
            public JavaFileObject next() {
                if (baseIterator.hasNext()) {
                    return (JavaFileObject)baseIterator.next();
                }
                if (myIterator.hasNext()) {
                    return (JavaFileObject)myIterator.next();
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        Iterable<JavaFileObject> iterable = new Iterable<JavaFileObject>(){

            @Override
            public Iterator<JavaFileObject> iterator() {
                return iterator;
            }
        };
        return iterable;
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fallbackFileManager.isSupportedOption(option);
    }
}

