/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class OptionsParser {
    private Path[] pluginDirectories;
    private Path home;

    public OptionsParser(String ... args) {
        Options options = new Options();
        options.addOption("plugins", true, "Directory from which to load a plugin bundle, can be used multiple times for different plugin bundles");
        options.addOption("home", true, "The home directory to use, default is [cwd]/home");
        DefaultParser parser = new DefaultParser();
        this.pluginDirectories = null;
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("plugins")) {
                String[] plugins = cmd.getOptionValues("plugins");
                this.pluginDirectories = new Path[plugins.length];
                for (int i = 0; i < plugins.length; ++i) {
                    this.pluginDirectories[i] = Paths.get(plugins[i], new String[0]);
                    if (Files.isDirectory(this.pluginDirectories[i], new LinkOption[0])) continue;
                    throw new RuntimeException("plugins parameter must point to a directory (" + this.pluginDirectories[i] + ")");
                }
            }
            if (cmd.hasOption("home")) {
                this.home = Paths.get(cmd.getOptionValue("home"), new String[0]);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Path[] getPluginDirectories() {
        return this.pluginDirectories;
    }

    public Path getHome() {
        return this.home;
    }
}

