/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFetcher.class);
    private final Set<Path> paths = new LinkedHashSet<Path>();

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public byte[] getData(String key) throws IOException {
        Path path = this.getPath(key);
        if (path != null) {
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    return FileUtils.readFileToByteArray((File)path.toFile());
                }
            }
            catch (MalformedURLException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    public Set<String> listKeys(String key) {
        Path path = this.getPath(key);
        HashSet<String> result = new HashSet<String>();
        if (path != null) {
            try {
                for (Path path2 : Files.newDirectoryStream(path)) {
                    result.add(path2.getFileName().toString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isDirectory(String key) {
        Path path = this.getPath(key);
        if (path != null) {
            return Files.isDirectory(path, new LinkOption[0]);
        }
        return false;
    }

    protected Path getPath(String key) {
        for (Path path : this.paths) {
            Path resolved = path.resolve(key);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return resolved;
        }
        return null;
    }

    public URL getURL(String key) throws MalformedURLException {
        URL url = this.getPath(key).toUri().toURL();
        return url;
    }
}

