/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import org.bimserver.plugins.VirtualFile;
import org.slf4j.LoggerFactory;

public class VirtualClassLoader
extends ClassLoader {
    private final VirtualFile baseDir;

    public VirtualClassLoader(ClassLoader parent, VirtualFile baseDir) {
        super(parent);
        this.baseDir = baseDir;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        VirtualFile virtualFile = this.baseDir.getClass(name);
        if (virtualFile != null) {
            byte[] bytes = virtualFile.getData();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        LoggerFactory.getLogger(VirtualClassLoader.class).info(name);
        if (name.equals("org.bimserver.jqep.QueryInterface") || name.equals("org.bimserver.javamodelchecker.JavaModelCheckerInterface")) {
            return super.findClass(name);
        }
        LoggerFactory.getLogger(VirtualClassLoader.class).info(name);
        throw new ClassNotFoundException();
    }
}

