/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins.classloaders;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bimserver.plugins.classloaders.JarClassLoader;
import org.bimserver.plugins.classloaders.PublicFindClassClassLoader;
import org.bimserver.utils.StringUtils;

public class DelegatingClassLoader
extends PublicFindClassClassLoader {
    private final Set<PublicFindClassClassLoader> jarClassLoaders = new LinkedHashSet<PublicFindClassClassLoader>();

    public DelegatingClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    public void add(PublicFindClassClassLoader jarClassLoader) {
        this.jarClassLoaders.add(jarClassLoader);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> loadClass = super.loadClass(name, resolve);
            if (loadClass != null) {
                return loadClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (PublicFindClassClassLoader jarClassLoader : this.jarClassLoaders) {
            Class<?> findClass;
            if (jarClassLoader instanceof JarClassLoader) {
                findClass = jarClassLoader.findClass(name);
                if (findClass == null) continue;
                return findClass;
            }
            try {
                findClass = jarClassLoader.loadClass(name);
                if (findClass == null) continue;
                return findClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        for (PublicFindClassClassLoader jarClassLoader : this.jarClassLoaders) {
            try {
                Class<?> findClass = jarClassLoader.findClass(name);
                if (findClass == null) continue;
                return findClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL findResource(String name) {
        for (PublicFindClassClassLoader jarClassLoader : this.jarClassLoaders) {
            URL resource = jarClassLoader.findResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public void dumpStructure(int indent) {
        System.out.print(StringUtils.gen((String)"  ", (int)indent));
        System.out.println("DelegatingClassLoader");
        ClassLoader parentLoader = this.getParent();
        if (parentLoader instanceof PublicFindClassClassLoader) {
            ((PublicFindClassClassLoader)parentLoader).dumpStructure(indent + 1);
        }
        for (PublicFindClassClassLoader sub : this.jarClassLoaders) {
            sub.dumpStructure(indent + 1);
        }
    }
}

