/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.PluginSourceType;
import org.bimserver.plugins.web.WebModulePlugin;
import org.bimserver.shared.exceptions.PluginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebModulePlugin
implements WebModulePlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWebModulePlugin.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private PluginContext pluginContext;
    private static final DateFormat HTTP_EXPIRES = AbstractWebModulePlugin.expiresDateFormat();
    public static final String FAR_FUTURE_EXPIRE_DATE = HTTP_EXPIRES.format(AbstractWebModulePlugin.makeExpiresDate());

    public static DateFormat expiresDateFormat() {
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return httpDateFormat;
    }

    public void init(PluginContext pluginContext, PluginConfiguration systemSettings) throws PluginException {
        this.pluginContext = pluginContext;
    }

    private static Date makeExpiresDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.add(6, 120);
        return gregorianCalendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean service(String requestUri, HttpServletRequest httpServletRequest, HttpServletResponse response) {
        try {
            Path resolved;
            InputStream resourceAsInputStream;
            if (requestUri.startsWith(this.getDefaultContextPath())) {
                requestUri = requestUri.substring(this.getDefaultContextPath().length());
            }
            if (requestUri.equals("")) {
                LOGGER.info("Redirect");
                response.sendRedirect(httpServletRequest.getServletPath() + httpServletRequest.getPathInfo() + "/");
            }
            if (requestUri.equals("/")) {
                requestUri = "index.html";
            }
            while (requestUri.startsWith("/")) {
                requestUri = requestUri.substring(1);
            }
            if (requestUri.endsWith("plugin.version")) {
                ObjectNode version = OBJECT_MAPPER.createObjectNode();
                version.put("groupId", this.pluginContext.getPluginBundle().getPluginBundleVersion().getGroupId());
                version.put("artifactId", this.pluginContext.getPluginBundle().getPluginBundleVersion().getArtifactId());
                version.put("version", this.pluginContext.getPluginBundle().getPluginBundleVersion().getVersion());
                version.put("description", this.pluginContext.getPluginBundle().getPluginBundleVersion().getDescription());
                version.put("icon", this.pluginContext.getPluginBundle().getPluginBundleVersion().getIcon());
                version.put("name", this.pluginContext.getPluginBundle().getPluginBundleVersion().getName());
                version.put("organization", this.pluginContext.getPluginBundle().getPluginBundleVersion().getOrganization());
                if (this.getPluginContext().getPluginType() == PluginSourceType.INTERNAL) {
                    return false;
                }
                if (this.getPluginContext().getPluginType() == PluginSourceType.ECLIPSE_PROJECT) {
                    version.put("nonce", System.nanoTime());
                    response.setContentType("application/json");
                    response.getOutputStream().write(version.toString().getBytes(Charsets.UTF_8));
                    return true;
                }
                if (this.getPluginContext().getPluginType() == PluginSourceType.JAR_FILE) {
                    version.put("nonce", this.pluginContext.getPluginBundle().getPluginBundleVersion().getVersion());
                    response.setContentType("application/json");
                    response.getOutputStream().write(version.toString().getBytes(Charsets.UTF_8));
                    return true;
                }
            }
            if (!requestUri.equals("index.html")) {
                // empty if block
            }
            if ((resourceAsInputStream = Files.newInputStream(resolved = this.pluginContext.getRootPath().resolve(this.getInternalPath() + requestUri), new OpenOption[0])) != null) {
                try {
                    IOUtils.copy((InputStream)resourceAsInputStream, (OutputStream)response.getOutputStream());
                }
                finally {
                    resourceAsInputStream.close();
                }
                return true;
            }
            return false;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public abstract String getIdentifier();

    public abstract String getInternalPath();

    public abstract String getDefaultContextPath();

    public ObjectDefinition getUserSettingsDefinition() {
        ObjectDefinition objectDefinition = StoreFactory.eINSTANCE.createObjectDefinition();
        PrimitiveDefinition stringDefinition = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringDefinition.setType(PrimitiveEnum.STRING);
        ParameterDefinition contextPathParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        contextPathParameter.setIdentifier("contextPath");
        contextPathParameter.setName("contextPath");
        contextPathParameter.setDescription("Context Path to run this Web Module on");
        StringType defaultValue = StoreFactory.eINSTANCE.createStringType();
        defaultValue.setValue(this.getDefaultContextPath());
        contextPathParameter.setDefaultValue((Type)defaultValue);
        contextPathParameter.setType((TypeDefinition)stringDefinition);
        objectDefinition.getParameters().add((Object)contextPathParameter);
        return objectDefinition;
    }

    public ObjectDefinition getSystemSettingsDefinition() {
        return null;
    }

    public PluginContext getPluginContext() {
        return this.pluginContext;
    }
}

