/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.shared.AbstractByteBufferVirtualObject;
import org.bimserver.shared.ByteBufferWrappedVirtualObject;
import org.bimserver.shared.ListCapableVirtualObject;
import org.bimserver.shared.QueryContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ByteBufferList
extends AbstractByteBufferVirtualObject
implements ListCapableVirtualObject {
    private int currentListStart = -1;
    private int currentListSize;
    private int featureCounter;
    private EClass eClass;
    private QueryContext reusable;

    public ByteBufferList(QueryContext reusable, EClass eClass) {
        super(2);
        this.reusable = reusable;
        this.eClass = eClass;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.putShort(-reusable.getDatabaseInterface().getCidOfEClass(eClass));
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    private void incrementFeatureCounter(EStructuralFeature feature) {
        ++this.featureCounter;
    }

    public void startList(EStructuralFeature feature) {
        this.ensureCapacity(this.buffer.position(), 4);
        this.buffer.putInt(0);
        this.currentListStart = this.buffer.position();
        this.currentListSize = 0;
        this.incrementFeatureCounter(feature);
    }

    public void endList() {
        this.buffer.putInt(this.currentListStart - 4, this.currentListSize);
        this.currentListStart = -1;
    }

    public void setListItem(EStructuralFeature feature, int index, Object value) throws BimserverDatabaseException {
        if (this.currentListStart == -1) {
            throw new BimserverDatabaseException("Not currently writing a list");
        }
        if (index + 1 > this.currentListSize) {
            this.currentListSize = index + 1;
        }
        if (value instanceof ByteBufferWrappedVirtualObject) {
            ByteBuffer otherBuffer = ((ByteBufferWrappedVirtualObject)((Object)value)).write();
            this.ensureCapacity(this.buffer.position(), otherBuffer.position());
            this.buffer.put(otherBuffer.array(), 0, otherBuffer.position());
        } else {
            this.writePrimitiveValue(feature, value);
        }
    }

    public int reserveSpaceForListReference() throws BimserverDatabaseException {
        if (this.currentListStart == -1) {
            throw new BimserverDatabaseException("Not currently writing a list");
        }
        ++this.currentListSize;
        int position = this.buffer.position();
        this.ensureCapacity(position, 8);
        this.buffer.putLong(-1L);
        return position;
    }

    public void setListItemReference(EStructuralFeature structuralFeature, int index, EClass referenceEClass, Long referencedOid, int bufferPosition) throws BimserverDatabaseException {
        int pos;
        if (bufferPosition == -1) {
            if (this.currentListStart == -1) {
                throw new BimserverDatabaseException("Not currently writing a list");
            }
            if (index + 1 > this.currentListSize) {
                this.currentListSize = index + 1;
            }
            pos = this.buffer.position();
        } else {
            pos = bufferPosition;
        }
        this.ensureCapacity(pos, 8);
        if (referencedOid < 0L) {
            throw new BimserverDatabaseException("Writing a reference with oid " + referencedOid + ", this is not supposed to happen, referenced: " + referencedOid + " " + referencedOid + " " + (Object)((Object)this));
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(pos, referencedOid);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        if (bufferPosition == -1) {
            this.buffer.position(this.buffer.position() + 8);
        }
    }

    public EClass eClass() {
        return this.eClass;
    }

    public ByteBuffer write() {
        return this.buffer;
    }

    public int size() {
        return this.buffer.position();
    }
}

