/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared;

import java.nio.ByteBuffer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.shared.AbstractByteBufferVirtualObject;
import org.bimserver.shared.ByteBufferWrappedVirtualObject;
import org.bimserver.shared.ListCapableVirtualObject;
import org.bimserver.shared.QueryContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PrimitiveByteBufferList
extends AbstractByteBufferVirtualObject
implements ListCapableVirtualObject {
    private QueryContext reusable;
    private EDataType eDataType;
    private int currentListStart = -1;
    private int currentListSize;
    private int featureCounter;

    public PrimitiveByteBufferList(QueryContext reusable, EDataType eDataType) {
        super(2);
        this.reusable = reusable;
        this.eDataType = eDataType;
    }

    public void startList(EStructuralFeature structuralFeature) {
        this.ensureCapacity(this.buffer.position(), 4);
        this.buffer.putInt(0);
        this.currentListStart = this.buffer.position();
        this.currentListSize = 0;
        this.incrementFeatureCounter(structuralFeature);
    }

    private void incrementFeatureCounter(EStructuralFeature feature) {
        ++this.featureCounter;
    }

    public void endList() {
        this.buffer.putInt(this.currentListStart - 4, this.currentListSize);
        this.currentListStart = -1;
    }

    public void setListItem(EStructuralFeature feature, int index, Object value) throws BimserverDatabaseException {
        if (this.currentListStart == -1) {
            throw new BimserverDatabaseException("Not currently writing a list");
        }
        if (index + 1 > this.currentListSize) {
            this.currentListSize = index + 1;
        }
        if (value instanceof ByteBufferWrappedVirtualObject) {
            ByteBuffer otherBuffer = ((ByteBufferWrappedVirtualObject)((Object)value)).write();
            this.ensureCapacity(this.buffer.position(), otherBuffer.position());
            this.buffer.put(otherBuffer.array(), 0, otherBuffer.position());
        } else {
            this.writePrimitiveValue(feature, value);
        }
    }

    public int reserveSpaceForListReference() throws BimserverDatabaseException {
        return 0;
    }

    public void setListItemReference(EStructuralFeature structuralFeature, int index, EClass referenceEClass, Long referencedOid, int i) throws BimserverDatabaseException {
    }

    public ByteBuffer write() {
        return this.buffer;
    }
}

