/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bimserver.shared.json.ConvertException;
import org.bimserver.shared.meta.SBase;
import org.bimserver.shared.meta.SClass;
import org.bimserver.shared.meta.SField;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.utils.ByteArrayDataSource;

public class JsonConverter {
    private final SServicesMap servicesMap;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public JsonConverter(SServicesMap servicesMap) {
        this.servicesMap = servicesMap;
    }

    public JsonNode toJson(Object object) throws IOException {
        if (object instanceof SBase) {
            SBase base = (SBase)object;
            ObjectNode jsonObject = OBJECT_MAPPER.createObjectNode();
            jsonObject.put("__type", base.getSClass().getSimpleName());
            for (SField field : base.getSClass().getAllFields()) {
                jsonObject.set(field.getName(), this.toJson(base.sGet(field)));
            }
            return jsonObject;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayNode jsonArray = OBJECT_MAPPER.createArrayNode();
            for (Object value : collection) {
                jsonArray.add(this.toJson(value));
            }
            return jsonArray;
        }
        if (object instanceof Date) {
            return new LongNode(((Date)object).getTime());
        }
        if (object instanceof DataHandler) {
            DataHandler dataHandler = (DataHandler)object;
            InputStream inputStream = dataHandler.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            return new TextNode(new String(Base64.encodeBase64((byte[])out.toByteArray()), Charsets.UTF_8));
        }
        if (object instanceof Boolean) {
            return BooleanNode.valueOf((boolean)((Boolean)object));
        }
        if (object instanceof String) {
            return new TextNode((String)object);
        }
        if (object instanceof Long) {
            return new LongNode(((Long)object).longValue());
        }
        if (object instanceof UUID) {
            return new TextNode(((UUID)object).toString());
        }
        if (object instanceof Integer) {
            return new IntNode(((Integer)object).intValue());
        }
        if (object instanceof Double) {
            return new DoubleNode(((Double)object).doubleValue());
        }
        if (object instanceof Float) {
            return new FloatNode(((Float)object).floatValue());
        }
        if (object instanceof Enum) {
            return new TextNode(object.toString());
        }
        if (object == null) {
            return NullNode.getInstance();
        }
        if (object instanceof byte[]) {
            byte[] data = (byte[])object;
            return new TextNode(new String(Base64.encodeBase64((byte[])data), Charsets.UTF_8));
        }
        throw new UnsupportedOperationException(object.getClass().getName());
    }

    public Object fromJson(SClass definedType, SClass genericType, Object object) throws ConvertException, IOException {
        try {
            if (object instanceof ObjectNode) {
                ObjectNode jsonObject = (ObjectNode)object;
                if (jsonObject.has("__type")) {
                    String type = jsonObject.get("__type").asText();
                    SClass sClass = this.servicesMap.getType(type);
                    if (sClass == null) {
                        throw new ConvertException("Unknown type: " + type);
                    }
                    SBase newObject = sClass.newInstance();
                    for (SField field : newObject.getSClass().getAllFields()) {
                        if (!jsonObject.has(field.getName())) continue;
                        newObject.sSet(field, this.fromJson(field.getType(), field.getGenericType(), jsonObject.get(field.getName())));
                    }
                    return newObject;
                }
                Iterator fieldNames = jsonObject.fieldNames();
                int nrFields = 0;
                while (fieldNames.hasNext()) {
                    ++nrFields;
                    fieldNames.next();
                }
                if (nrFields != 0) {
                    throw new ConvertException("Missing __type field in " + jsonObject.toString());
                }
                return null;
            }
            if (object instanceof ArrayNode) {
                ArrayNode array = (ArrayNode)object;
                if (definedType.isList()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < array.size(); ++i) {
                        list.add(this.fromJson(definedType, genericType, array.get(i)));
                    }
                    return list;
                }
                if (definedType.isSet()) {
                    HashSet<Object> set = new HashSet<Object>();
                    for (int i = 0; i < array.size(); ++i) {
                        set.add(this.fromJson(definedType, genericType, array.get(i)));
                    }
                    return set;
                }
            } else {
                if (object instanceof NullNode) {
                    return null;
                }
                if (definedType.isByteArray()) {
                    if (object instanceof ValueNode) {
                        ValueNode jsonPrimitive = (ValueNode)object;
                        return Base64.decodeBase64((byte[])jsonPrimitive.asText().getBytes(Charsets.UTF_8));
                    }
                } else if (definedType.isDataHandler()) {
                    if (object instanceof ValueNode) {
                        ValueNode jsonPrimitive = (ValueNode)object;
                        byte[] data = Base64.decodeBase64((byte[])jsonPrimitive.asText().getBytes(Charsets.UTF_8));
                        return new DataHandler((DataSource)new ByteArrayDataSource(null, data));
                    }
                } else if (definedType.isInteger()) {
                    if (object instanceof ValueNode) {
                        return ((ValueNode)object).asInt();
                    }
                } else if (definedType.isLong()) {
                    if (object instanceof ValueNode) {
                        return ((ValueNode)object).asLong();
                    }
                } else if (definedType.isShort()) {
                    if (object instanceof ValueNode) {
                        return (short)((ValueNode)object).asInt();
                    }
                } else if (definedType.isEnum()) {
                    ValueNode primitive = (ValueNode)object;
                    for (Object enumConstantObject : definedType.getInstanceClass().getEnumConstants()) {
                        Enum enumConstant = (Enum)enumConstantObject;
                        if (!enumConstant.name().equals(primitive.asText())) continue;
                        return enumConstant;
                    }
                } else if (definedType.isDate()) {
                    if (object instanceof ValueNode) {
                        return new Date(((ValueNode)object).asLong());
                    }
                } else if (definedType.isString()) {
                    if (object instanceof ValueNode) {
                        return ((ValueNode)object).asText();
                    }
                    if (object instanceof NullNode) {
                        return null;
                    }
                } else if (definedType.isUuid()) {
                    if (object instanceof TextNode) {
                        return UUID.fromString(((TextNode)object).asText());
                    }
                    if (object instanceof NullNode) {
                        return null;
                    }
                } else if (definedType.isBoolean()) {
                    if (object instanceof ValueNode) {
                        return ((ValueNode)object).asBoolean();
                    }
                } else if (definedType.isList()) {
                    if (genericType.isLong()) {
                        if (object instanceof ValueNode) {
                            return ((ValueNode)object).asLong();
                        }
                    } else if (genericType.isInteger()) {
                        if (object instanceof ValueNode) {
                            return ((ValueNode)object).asInt();
                        }
                    } else if (genericType.isString()) {
                        if (object instanceof ValueNode) {
                            return ((ValueNode)object).asText();
                        }
                    } else if (genericType.isDouble() && object instanceof ValueNode) {
                        return ((ValueNode)object).asDouble();
                    }
                } else if (definedType.isSet()) {
                    if (genericType.isLong()) {
                        if (object instanceof ValueNode) {
                            return ((ValueNode)object).asLong();
                        }
                    } else if (genericType.isInteger()) {
                        if (object instanceof ValueNode) {
                            return ((ValueNode)object).asInt();
                        }
                    } else if (genericType.isString() && object instanceof ValueNode) {
                        return ((ValueNode)object).asText();
                    }
                } else if (definedType.isDouble()) {
                    if (object instanceof ValueNode) {
                        return ((ValueNode)object).asDouble();
                    }
                } else if (definedType.isFloat()) {
                    if (object instanceof ValueNode) {
                        return Float.valueOf((float)((ValueNode)object).asDouble());
                    }
                } else if (definedType.isVoid()) {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new ConvertException(e);
        }
        throw new UnsupportedOperationException(object.toString());
    }
}

