/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.pb;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ServiceMethodNotFoundException;
import org.bimserver.shared.pb.ServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolBuffersMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolBuffersMetaData.class);
    private final Map<String, ServiceDescriptorContainer> serviceDescriptors = new HashMap<String, ServiceDescriptorContainer>();
    private final Map<String, MessageDescriptorContainer> messageDescriptors = new HashMap<String, MessageDescriptorContainer>();
    private final Map<String, Descriptors.FileDescriptor> loaded = new HashMap<String, Descriptors.FileDescriptor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String load(InputStream inputStream) {
        try {
            DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream);
            List fileList = descriptorSet.getFileList();
            DescriptorProtos.FileDescriptorProto fileDescriptorProto = (DescriptorProtos.FileDescriptorProto)fileList.get(0);
            Descriptors.FileDescriptor[] ar = new Descriptors.FileDescriptor[fileDescriptorProto.getDependencyCount()];
            int i = 0;
            for (String dep : fileDescriptorProto.getDependencyList()) {
                Descriptors.FileDescriptor fileDescriptor = this.loaded.get(dep);
                if (fileDescriptor == null) {
                    LOGGER.error("Dependency " + dep + " of " + fileDescriptorProto.getName() + " not found");
                }
                ar[i++] = fileDescriptor;
            }
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])ar);
            this.loaded.put(fileDescriptor.getName(), fileDescriptor);
            for (Descriptors.Descriptor descriptor : fileDescriptor.getMessageTypes()) {
                this.messageDescriptors.put(descriptor.getName(), new MessageDescriptorContainer(descriptor));
            }
            Iterator iterator = fileDescriptor.getServices().iterator();
            if (iterator.hasNext()) {
                Descriptors.ServiceDescriptor serviceDescriptor = (Descriptors.ServiceDescriptor)iterator.next();
                this.serviceDescriptors.put(serviceDescriptor.getName(), new ServiceDescriptorContainer(serviceDescriptor));
                String string = serviceDescriptor.getName();
                return string;
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (Descriptors.DescriptorValidationException e) {
            LOGGER.error("", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    public String load(URL url) throws IOException {
        return this.load(url.openStream());
    }

    public void load(File file) throws FileNotFoundException {
        this.load(new FileInputStream(file));
    }

    public Collection<MethodDescriptorContainer> getMethods(String serviceName) {
        return this.serviceDescriptors.get(serviceName).getMethodDescriptors();
    }

    public MethodDescriptorContainer getMethod(String serviceName, String methodName) throws ServiceNotFoundException, ServiceMethodNotFoundException {
        ServiceDescriptorContainer serviceDescriptorContainer = this.serviceDescriptors.get(serviceName);
        if (serviceDescriptorContainer == null) {
            throw new ServiceNotFoundException("No service with name " + serviceName + " was found");
        }
        MethodDescriptorContainer methodDescriptor = serviceDescriptorContainer.getMethodDescriptor(methodName);
        if (methodDescriptor == null) {
            throw new ServiceMethodNotFoundException("No method with name " + methodName + " was found on service " + serviceName);
        }
        return methodDescriptor;
    }

    public MessageDescriptorContainer getMessageDescriptor(String name) {
        return this.messageDescriptors.get(name);
    }

    public Collection<ServiceDescriptorContainer> getServices() {
        return this.serviceDescriptors.values();
    }

    public void load(SServicesMap servicesMap, Class<?> loaderClass) {
        try {
            for (Class clazz : servicesMap.getInterfaceClasses()) {
                URL resource = loaderClass.getResource(clazz.getSimpleName() + ".desc");
                if (resource != null) {
                    this.load(resource);
                    continue;
                }
                LOGGER.error("Resource not found");
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public static class MessageDescriptorContainer {
        private final Map<String, Descriptors.FieldDescriptor> fieldDescriptors = new HashMap<String, Descriptors.FieldDescriptor>();
        private final Descriptors.Descriptor descriptor;

        public MessageDescriptorContainer(Descriptors.Descriptor descriptor) {
            this.descriptor = descriptor;
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                this.fieldDescriptors.put(fieldDescriptor.getName(), fieldDescriptor);
            }
        }

        public Descriptors.Descriptor getDescriptor() {
            return this.descriptor;
        }

        public Descriptors.FieldDescriptor getField(String name) {
            return this.fieldDescriptors.get(name);
        }
    }

    public static class MethodDescriptorContainer {
        private final Map<String, Descriptors.FieldDescriptor> inputFields = new HashMap<String, Descriptors.FieldDescriptor>();
        private final Map<String, Descriptors.FieldDescriptor> outputFields = new HashMap<String, Descriptors.FieldDescriptor>();
        private final Descriptors.MethodDescriptor methodDescriptor;
        private final ServiceDescriptorContainer serviceDescriptorContainer;

        public MethodDescriptorContainer(ServiceDescriptorContainer serviceDescriptorContainer, Descriptors.MethodDescriptor methodDescriptor) {
            this.serviceDescriptorContainer = serviceDescriptorContainer;
            this.methodDescriptor = methodDescriptor;
            for (Descriptors.FieldDescriptor fieldDescriptor : methodDescriptor.getInputType().getFields()) {
                this.inputFields.put(fieldDescriptor.getName(), fieldDescriptor);
            }
            for (Descriptors.FieldDescriptor fieldDescriptor : methodDescriptor.getOutputType().getFields()) {
                this.outputFields.put(fieldDescriptor.getName(), fieldDescriptor);
            }
        }

        public ServiceDescriptorContainer getServiceDescriptorContainer() {
            return this.serviceDescriptorContainer;
        }

        public Descriptors.FieldDescriptor getInputField(String name) {
            return this.inputFields.get(name);
        }

        public Descriptors.FieldDescriptor getOutputField(String name) {
            return this.outputFields.get(name);
        }

        public Descriptors.Descriptor getInputDescriptor() {
            return this.methodDescriptor.getInputType();
        }

        public Descriptors.Descriptor getOutputDescriptor() {
            return this.methodDescriptor.getOutputType();
        }

        public Descriptors.MethodDescriptor getMethodDescriptor() {
            return this.methodDescriptor;
        }

        public String getName() {
            return this.methodDescriptor.getName();
        }
    }

    public static class ServiceDescriptorContainer {
        private final Map<String, MethodDescriptorContainer> methodDescriptors = new HashMap<String, MethodDescriptorContainer>();
        private final Descriptors.ServiceDescriptor serviceDescriptor;

        public ServiceDescriptorContainer(Descriptors.ServiceDescriptor serviceDescriptor) {
            this.serviceDescriptor = serviceDescriptor;
            for (Descriptors.MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
                this.methodDescriptors.put(methodDescriptor.getName(), new MethodDescriptorContainer(this, methodDescriptor));
            }
        }

        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return this.serviceDescriptor;
        }

        public Collection<MethodDescriptorContainer> getMethodDescriptors() {
            return this.methodDescriptors.values();
        }

        public MethodDescriptorContainer getMethodDescriptor(String methodName) {
            return this.methodDescriptors.get(methodName);
        }

        public String getName() {
            return this.serviceDescriptor.getName();
        }
    }
}

