/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.pb;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.meta.SBase;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SParameter;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ProtocolBuffersConverter;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.reflector.KeyValuePair;
import org.bimserver.utils.ByteArrayDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveRpcChannel
extends ProtocolBuffersConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveRpcChannel.class);
    private final ProtocolBuffersMetaData protocolBuffersMetaData;
    private Class<? extends PublicInterface> publicInterface = null;
    private final PublicInterface service;
    private SServicesMap servicesMap;

    public ReflectiveRpcChannel(Class<? extends PublicInterface> publicInterface, PublicInterface service, ProtocolBuffersMetaData protocolBuffersMetaData, SServicesMap servicesMap) {
        super(protocolBuffersMetaData);
        this.service = service;
        this.publicInterface = publicInterface;
        this.protocolBuffersMetaData = protocolBuffersMetaData;
        this.servicesMap = servicesMap;
    }

    public Message callBlockingMethod(ProtocolBuffersMetaData.MethodDescriptorContainer methodDescriptor, Message request) {
        Descriptors.FieldDescriptor errorMessageField = methodDescriptor.getOutputField("errorMessage");
        DynamicMessage response = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)methodDescriptor.getOutputDescriptor());
        Descriptors.Descriptor inputType = methodDescriptor.getInputDescriptor();
        SMethod sMethod = this.servicesMap.getBySimpleName(methodDescriptor.getServiceDescriptorContainer().getName()).getSMethod(methodDescriptor.getName());
        if (sMethod == null) {
            LOGGER.info("Method " + methodDescriptor.getName() + " not found");
            return null;
        }
        try {
            KeyValuePair[] arguments = new KeyValuePair[inputType.getFields().size()];
            int i = 0;
            for (Descriptors.FieldDescriptor fieldDescriptor : inputType.getFields()) {
                SParameter sParameter = sMethod.getParameter(i);
                Object value = request.getField(fieldDescriptor);
                if (value instanceof Descriptors.EnumValueDescriptor) {
                    Descriptors.EnumValueDescriptor enumValueDescriptor = (Descriptors.EnumValueDescriptor)value;
                    Class<?> en = this.getJavaType(fieldDescriptor);
                    arguments[i] = new KeyValuePair(fieldDescriptor.getName(), en.getEnumConstants()[enumValueDescriptor.getIndex()]);
                } else if (value instanceof ByteString) {
                    ByteString byteString = (ByteString)value;
                    ByteArrayDataSource dataSource = new ByteArrayDataSource("bytes", byteString.toByteArray());
                    DataHandler dataHandler = new DataHandler((DataSource)dataSource);
                    arguments[i] = new KeyValuePair(fieldDescriptor.getName(), (Object)dataHandler);
                } else if (value instanceof DynamicMessage) {
                    arguments[i] = new KeyValuePair(fieldDescriptor.getName(), (Object)this.convertProtocolBuffersMessageToSObject((Message)((DynamicMessage)value), null, sParameter.getType()));
                } else if (value instanceof Collection) {
                    Collection col = (Collection)value;
                    if (sParameter.getType().isList()) {
                        ArrayList list = new ArrayList(col);
                        arguments[i] = new KeyValuePair(fieldDescriptor.getName(), list);
                    } else if (sParameter.getType().isSet()) {
                        HashSet set = new HashSet(col);
                        arguments[i] = new KeyValuePair(fieldDescriptor.getName(), set);
                    }
                } else {
                    arguments[i] = new KeyValuePair(fieldDescriptor.getName(), value);
                }
                ++i;
            }
            Object result = sMethod.invoke(this.publicInterface, this.service, arguments);
            DynamicMessage.Builder builder = response.newBuilderForType();
            if (methodDescriptor.getOutputDescriptor().getName().equals("VoidResponse")) {
                builder.setField(errorMessageField, (Object)"OKE");
            } else {
                Descriptors.FieldDescriptor valueField = this.protocolBuffersMetaData.getMessageDescriptor(response.getDescriptorForType().getName()).getField("value");
                if (result != null) {
                    ArrayList<Message> list;
                    if (valueField.getType().getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                        builder.setField(valueField, (Object)valueField.getEnumType().findValueByName(result.toString()));
                    } else if (valueField.getType().getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        if (result instanceof Date) {
                            builder.setField(valueField, (Object)((Date)result).getTime());
                        } else if (valueField.isRepeated()) {
                            builder.setField(valueField, new ArrayList());
                        } else {
                            builder.setField(valueField, result);
                        }
                    } else if (result instanceof List) {
                        list = new ArrayList<Message>();
                        List originalList = (List)result;
                        for (Object object : originalList) {
                            list.add(this.convertSObjectToProtocolBuffersObject((SBase)object, sMethod.getBestReturnType()));
                        }
                        builder.setField(valueField, list);
                    } else if (result instanceof Set) {
                        list = new ArrayList();
                        Set originalSet = (Set)result;
                        for (Object object : originalSet) {
                            list.add(this.convertSObjectToProtocolBuffersObject((SBase)object, sMethod.getBestReturnType()));
                        }
                        builder.setField(valueField, list);
                    } else {
                        builder.setField(valueField, (Object)this.convertSObjectToProtocolBuffersObject((SBase)result, sMethod.getBestReturnType()));
                    }
                }
                builder.setField(errorMessageField, (Object)"OKE");
            }
            return builder.build();
        }
        catch (Exception e) {
            if (!(e instanceof ServiceException)) {
                LOGGER.error("", (Throwable)e);
            }
            DynamicMessage.Builder errorMessage = response.newBuilderForType();
            if (e.getMessage() != null) {
                errorMessage.setField(errorMessageField, (Object)e.getMessage());
            } else {
                LOGGER.error("", (Throwable)e);
                errorMessage.setField(errorMessageField, (Object)"Unknown error");
            }
            return errorMessage.build();
        }
    }
}

