/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.reflector;

import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.commons.lang.RandomStringUtils;
import org.bimserver.generated.GeneratedNeighbourClass;
import org.bimserver.reflector.NeighbourClass;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SParameter;
import org.bimserver.shared.meta.SService;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.KeyValuePair;
import org.bimserver.shared.reflector.Reflector;
import org.bimserver.shared.reflector.ReflectorFactory;
import org.bimserver.shared.reflector.ReflectorFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeReflectorFactoryBuilder
implements ReflectorFactoryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeReflectorFactoryBuilder.class);
    private SServicesMap servicesMap;
    private ClassPool pool;
    private String prefix;
    private static volatile int implementationCounter = 0;
    private static final String GENERATED_CLASSES_PACKAGE = "org.bimserver.generated";

    public RealtimeReflectorFactoryBuilder(SServicesMap servicesMap) {
        this.servicesMap = servicesMap;
        this.prefix = RandomStringUtils.randomAlphabetic((int)12);
    }

    public ReflectorFactory newReflectorFactory() {
        try {
            this.pool = ClassPool.getDefault();
            this.pool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
            this.pool.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
            String newClassPrefix = this.getNewClassPrefix();
            for (String name : this.servicesMap.keySetName()) {
                SService sService = this.servicesMap.getByName(name);
                this.build1(newClassPrefix, sService.getInterfaceClass(), sService);
                this.build2(newClassPrefix, sService.getInterfaceClass(), sService);
            }
            CtClass reflectorFactoryImpl = this.pool.makeClass("org.bimserver.reflector.ReflectorFactoryImpl" + newClassPrefix);
            reflectorFactoryImpl.addInterface(this.pool.get(ReflectorFactory.class.getName()));
            this.createCreateReflectorMethod1(newClassPrefix, reflectorFactoryImpl);
            this.createCreateReflectorMethod2(newClassPrefix, reflectorFactoryImpl);
            Class class1 = this.pool.toClass(reflectorFactoryImpl, NeighbourClass.class, this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
            return (ReflectorFactory)class1.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    private String getNewClassPrefix() {
        return this.prefix + "_" + ++implementationCounter;
    }

    private void createCreateReflectorMethod2(String newClassPrefix, CtClass reflectorFactoryImpl) throws NotFoundException, CannotCompileException {
        CtClass[] parameters = new CtClass[]{this.pool.get(Class.class.getName()), this.pool.get(PublicInterface.class.getName())};
        CtMethod method = new CtMethod(this.pool.get(Reflector.class.getName()), "createReflector", parameters, reflectorFactoryImpl);
        StringBuilder methodBuilder = new StringBuilder();
        methodBuilder.append("{");
        methodBuilder.append("if (1==0) {");
        for (String name : this.servicesMap.keySetName()) {
            SService sService = this.servicesMap.getByName(name);
            methodBuilder.append("} else if ($1.getSimpleName().equals(\"" + sService.getSimpleName() + "\")) {");
            methodBuilder.append("return new org.bimserver.generated." + sService.getSimpleName() + "Reflector" + newClassPrefix + "((" + sService.getInterfaceClass().getName() + ")$2);");
        }
        methodBuilder.append("}");
        methodBuilder.append("return null;");
        methodBuilder.append("}");
        method.setBody(methodBuilder.toString());
        reflectorFactoryImpl.addMethod(method);
    }

    private void createCreateReflectorMethod1(String newClassPrefix, CtClass reflectorFactoryImpl) throws NotFoundException, CannotCompileException {
        CtClass[] parameters = new CtClass[]{this.pool.get(Class.class.getName()), this.pool.get(Reflector.class.getName())};
        CtMethod method = new CtMethod(this.pool.get(PublicInterface.class.getName()), "createReflector", parameters, reflectorFactoryImpl);
        StringBuilder methodBuilder = new StringBuilder();
        methodBuilder.append("{");
        methodBuilder.append("if (1==0) {");
        for (String name : this.servicesMap.keySetName()) {
            SService sService = this.servicesMap.getByName(name);
            methodBuilder.append("} else if ($1.getSimpleName().equals(\"" + sService.getSimpleName() + "\")) {");
            methodBuilder.append("return new org.bimserver.generated." + sService.getSimpleName() + "Impl" + newClassPrefix + "($2);");
        }
        methodBuilder.append("}");
        methodBuilder.append("return null;");
        methodBuilder.append("}");
        method.setBody(methodBuilder.toString());
        reflectorFactoryImpl.addMethod(method);
    }

    private void build1(String newClassPrefix, Class<? extends PublicInterface> interfaceClass, SService sService) {
        try {
            CtClass reflectorImplClass = this.pool.makeClass("org.bimserver.generated." + interfaceClass.getSimpleName() + "Impl" + newClassPrefix);
            reflectorImplClass.addInterface(this.pool.get(interfaceClass.getName()));
            CtClass reflectorClass = this.pool.get(Reflector.class.getName());
            CtField reflectorField = new CtField(reflectorClass, "reflector", reflectorImplClass);
            reflectorImplClass.addField(reflectorField);
            CtConstructor constructor = new CtConstructor(new CtClass[]{reflectorClass}, reflectorImplClass);
            StringBuilder sb = new StringBuilder();
            reflectorImplClass.addConstructor(constructor);
            sb.append("{");
            sb.append("this.reflector = $1;");
            sb.append("}");
            constructor.setBody(sb.toString());
            for (SMethod sMethod : sService.getMethods()) {
                CtClass[] parameters = new CtClass[sMethod.getParameters().size()];
                int i = 0;
                for (SParameter sParameter : sMethod.getParameters()) {
                    parameters[i] = this.pool.get(sParameter.getType().toJavaCode());
                    ++i;
                }
                CtMethod method = new CtMethod(this.pool.get(sMethod.getReturnType().toJavaCode()), sMethod.getName(), parameters, reflectorImplClass);
                StringBuilder methodBuilder = new StringBuilder();
                methodBuilder.append("{");
                if (!sMethod.getReturnType().isVoid()) {
                    methodBuilder.append("return (" + sMethod.getReturnType().toJavaCode() + ")");
                }
                methodBuilder.append("reflector.callMethod(\"" + interfaceClass.getSimpleName() + "\", \"" + sMethod.getName() + "\", " + sMethod.getReturnType().toJavaCode() + ".class");
                if (sMethod.getParameters().isEmpty()) {
                    methodBuilder.append(", new " + KeyValuePair.class.getName() + "[0]");
                } else {
                    methodBuilder.append(", new " + KeyValuePair.class.getName() + "[]{");
                    int x = 1;
                    for (SParameter sParameter : sMethod.getParameters()) {
                        methodBuilder.append("new " + KeyValuePair.class.getName() + "(\"" + sParameter.getName() + "\", $" + x + ")");
                        if (sMethod.getParameter(sMethod.getParameters().size() - 1) != sParameter) {
                            methodBuilder.append(", ");
                        }
                        ++x;
                    }
                    methodBuilder.append("}");
                }
                methodBuilder.append(");");
                methodBuilder.append("}");
                method.setBody(methodBuilder.toString());
                reflectorImplClass.addMethod(method);
            }
            this.pool.toClass(reflectorImplClass, GeneratedNeighbourClass.class, this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void build2(String newClassPrefix, Class<? extends PublicInterface> interfaceClass, SService sService) {
        try {
            CtClass reflectorImplClass = this.pool.makeClass("org.bimserver.generated." + interfaceClass.getSimpleName() + "Reflector" + newClassPrefix);
            CtClass reflectorClass = this.pool.get(Reflector.class.getName());
            CtClass interfaceCtClass = this.pool.get(interfaceClass.getName());
            reflectorImplClass.addInterface(reflectorClass);
            CtField reflectorField = new CtField(interfaceCtClass, "publicInterface", reflectorImplClass);
            reflectorImplClass.addField(reflectorField);
            CtConstructor constructor = new CtConstructor(new CtClass[]{interfaceCtClass}, reflectorImplClass);
            StringBuilder sb = new StringBuilder();
            reflectorImplClass.addConstructor(constructor);
            sb.append("{");
            sb.append("this.publicInterface = $1;");
            sb.append("}");
            constructor.setBody(sb.toString());
            CtClass[] parameters = new CtClass[]{this.pool.get(String.class.getName()), this.pool.get(String.class.getName()), this.pool.get(Class.class.getName()), this.pool.get(KeyValuePair.class.getName() + "[]")};
            CtMethod method = new CtMethod(this.pool.get(Object.class.getName()), "callMethod", parameters, reflectorImplClass);
            StringBuilder methodBuilder = new StringBuilder();
            methodBuilder.append("{");
            methodBuilder.append("if  (1==0) {} ");
            for (SMethod sMethod : sService.getMethods()) {
                methodBuilder.append(" else if ($2.equals(\"" + sMethod.getName() + "\")) {");
                if (!sMethod.getReturnType().isVoid()) {
                    methodBuilder.append("return ");
                }
                methodBuilder.append("publicInterface." + sMethod.getName() + "(");
                int i = 0;
                for (SParameter sParameter : sMethod.getParameters()) {
                    methodBuilder.append("(" + sParameter.getType().toJavaCode() + ")$4[" + i + "].getValue()");
                    if (i < sMethod.getParameters().size() - 1) {
                        methodBuilder.append(", ");
                    }
                    ++i;
                }
                methodBuilder.append(");");
                methodBuilder.append("}");
            }
            methodBuilder.append("return null;");
            methodBuilder.append("}");
            method.setBody(methodBuilder.toString());
            reflectorImplClass.addMethod(method);
            this.pool.toClass(reflectorImplClass, GeneratedNeighbourClass.class, this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

