/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.utils;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static <A> List<Class<A>> getClassesAsList(String pckgname, Class<A> type) throws ClassNotFoundException {
        ArrayList<Class<A>> classes = new ArrayList<Class<A>>();
        File directory = null;
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            String path = pckgname.replace('.', '/');
            URL resource = cld.getResource(path);
            if (resource == null) {
                throw new ClassNotFoundException("No resource for " + path);
            }
            directory = new File(resource.getFile());
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(pckgname + " (" + directory + ") does not appear to be a valid package");
        }
        if (directory.exists()) {
            String[] files = directory.list();
            for (int i = 0; i < files.length; ++i) {
                Class<?> forName;
                if (!files[i].endsWith(".class") || !type.isAssignableFrom(forName = Class.forName(pckgname + '.' + files[i].substring(0, files[i].length() - 6))) || type == forName) continue;
                classes.add(forName);
            }
        } else {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package");
        }
        return classes;
    }
}

