/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.utils;

import java.util.HashMap;
import java.util.Map;
import org.bimserver.utils.Formatters;
import org.bimserver.utils.Measurement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsTable {
    private Map<String, Measurement> measurements = new HashMap<String, Measurement>();
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsTable.class);

    public void print() {
        for (String key : this.measurements.keySet()) {
            System.out.println(key + "\t" + Formatters.formatNanoSeconds(this.measurements.get(key).getTime()));
        }
    }

    private void checkExists(String key) {
        if (!this.measurements.containsKey(key)) {
            this.measurements.put(key, new Measurement());
        }
    }

    public void startMeasuring(String key) {
        this.checkExists(key);
        LOGGER.info(key + " Started");
        this.measurements.get(key).setStart(System.nanoTime());
    }

    public void stopMeasuring(String key) {
        this.checkExists(key);
        LOGGER.info(key + " Stopped");
        this.measurements.get(key).setStop(System.nanoTime());
    }

    public void stopStartMeasuring(String key1, String key2) {
        this.stopMeasuring(key1);
        this.startMeasuring(key2);
    }
}

