/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.validationreport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bimserver.validationreport.Issue;
import org.bimserver.validationreport.IssueBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueContainer
extends Issue {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueContainer.class);
    private final List<Issue> issues = new ArrayList<Issue>();
    private String title;

    public IssueBuilder builder() {
        return new IssueBuilder(this);
    }

    public void add(Issue issue) {
        this.issues.add(issue);
    }

    public Collection<Issue> list() {
        return this.issues;
    }

    public void dumpSummary() {
        LOGGER.info("Dumping IssueContainer");
        HashMap<String, AtomicInteger> map = new HashMap<String, AtomicInteger>();
        this.dumpSummary(map, 0);
        for (String key : map.keySet()) {
            LOGGER.info(key + ": " + map.get(key).get());
        }
    }

    public void dumpSummary(Map<String, AtomicInteger> map, int indentation) {
        for (Issue issue : this.issues) {
            AtomicInteger ai = map.get(issue.getOriginatigModelCheckName());
            if (ai == null) {
                ai = new AtomicInteger(0);
                map.put(issue.getOriginatigModelCheckName(), ai);
            }
            ai.incrementAndGet();
            if (!(issue instanceof IssueContainer)) continue;
            ((IssueContainer)issue).dumpSummary(map, indentation + 1);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

