/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle;

import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.opentcs.components.kernel.services.VehicleService;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.LoadHandlingDevice;
import org.opentcs.drivers.vehicle.VehicleCommAdapterEvent;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.drivers.vehicle.management.VehicleCommAdapterPanel;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.Comparators;
import org.opentcs.util.gui.StringListCellRenderer;
import org.opentcs.virtualvehicle.LoopbackVehicleModel;
import org.opentcs.virtualvehicle.LoopbackVehicleModelTO;
import org.opentcs.virtualvehicle.commands.CurrentMovementCommandFailedCommand;
import org.opentcs.virtualvehicle.commands.PublishEventCommand;
import org.opentcs.virtualvehicle.commands.SetEnergyLevelCommand;
import org.opentcs.virtualvehicle.commands.SetLoadHandlingDevicesCommand;
import org.opentcs.virtualvehicle.commands.SetOrientationAngleCommand;
import org.opentcs.virtualvehicle.commands.SetPositionCommand;
import org.opentcs.virtualvehicle.commands.SetPrecisePositionCommand;
import org.opentcs.virtualvehicle.commands.SetSingleStepModeEnabledCommand;
import org.opentcs.virtualvehicle.commands.SetStateCommand;
import org.opentcs.virtualvehicle.commands.SetVehiclePausedCommand;
import org.opentcs.virtualvehicle.commands.SetVehiclePropertyCommand;
import org.opentcs.virtualvehicle.commands.TriggerCommand;
import org.opentcs.virtualvehicle.inputcomponents.DropdownListInputPanel;
import org.opentcs.virtualvehicle.inputcomponents.InputDialog;
import org.opentcs.virtualvehicle.inputcomponents.InputPanel;
import org.opentcs.virtualvehicle.inputcomponents.SingleTextInputPanel;
import org.opentcs.virtualvehicle.inputcomponents.TripleTextInputPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopbackCommAdapterPanel
extends VehicleCommAdapterPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n/org/opentcs/commadapter/loopback/Bundle");
    private static final Logger LOG = LoggerFactory.getLogger(LoopbackCommAdapterPanel.class);
    private final VehicleService vehicleService;
    private LoopbackVehicleModelTO processModel;
    private final CallWrapper callWrapper;
    private JPanel PropsPowerInnerContainerPanel;
    private JPanel PropsPowerOuterContainerPanel;
    private JTextField appendixTxt;
    private JCheckBox chkBoxEnable;
    private JPanel connectionPanel;
    private JPanel controlTabPanel;
    private JPanel curPosPanel;
    private JLabel defaultOpTimeLbl;
    private JLabel defaultOpTimeUntiLbl;
    private JButton dispatchCommandFailedButton;
    private JButton dispatchEventButton;
    private JLabel energyLevelLabel;
    private JLabel energyLevelLbl;
    private JTextField energyLevelTxt;
    private JPanel eventPanel;
    private Box.Filler filler1;
    private JRadioButton flowModeRadioButton;
    private JCheckBox includeAppendixCheckBox;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel keyLabel;
    private JTextField keyTextField;
    private JCheckBox lHDCheckbox;
    private JPanel loadDevicePanel;
    private JLabel maxAccelLbl;
    private JTextField maxAccelTxt;
    private JLabel maxAccelUnitLbl;
    private JLabel maxDecelLbl;
    private JTextField maxDecelTxt;
    private JLabel maxDecelUnitLbl;
    private JLabel maxFwdVeloLbl;
    private JTextField maxFwdVeloTxt;
    private JLabel maxFwdVeloUnitLbl;
    private JLabel maxRevVeloLbl;
    private JTextField maxRevVeloTxt;
    private JLabel maxRevVeloUnitLbl;
    private ButtonGroup modeButtonGroup;
    private JTextField opTimeTxt;
    private JLabel orientationAngleLbl;
    private JTextField orientationAngleTxt;
    private JLabel orientationLabel;
    private JCheckBox pauseVehicleCheckBox;
    private JLabel pauseVehicleLabel;
    private JLabel positionLabel;
    private JTextField positionTxt;
    private JTextArea precisePosTextArea;
    private JLabel precisePosUnitLabel;
    private JPanel profilesContainerPanel;
    private JButton propSetButton;
    private ButtonGroup propertyEditorGroup;
    private JPanel propertySetterPanel;
    private JRadioButton removePropRadioBtn;
    private JRadioButton setPropValueRadioBtn;
    private JRadioButton singleModeRadioButton;
    private JPanel stateContainerPanel;
    private JTextField stateTxt;
    private JButton triggerButton;
    private JTextField valueTextField;
    private JPanel vehicleBahaviourPanel;
    private JPanel vehiclePropsPanel;
    private JPanel vehicleStatePanel;

    @Inject
    public LoopbackCommAdapterPanel(@Assisted LoopbackVehicleModelTO processModel, @Assisted VehicleService vehicleService, @ServiceCallWrapper CallWrapper callWrapper) {
        this.processModel = Objects.requireNonNull(processModel, "processModel");
        this.vehicleService = Objects.requireNonNull(vehicleService, "vehicleService");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
        this.initComponents();
        this.initGuiContent();
    }

    public void processModelChange(String attributeChanged, VehicleProcessModelTO newProcessModel) {
        if (!(newProcessModel instanceof LoopbackVehicleModelTO)) {
            return;
        }
        this.processModel = (LoopbackVehicleModelTO)newProcessModel;
        this.updateLoopbackVehicleModelData(attributeChanged, this.processModel);
        this.updateVehicleProcessModelData(attributeChanged, this.processModel);
    }

    private void initGuiContent() {
        for (VehicleProcessModel.Attribute attribute : VehicleProcessModel.Attribute.values()) {
            this.processModelChange(attribute.name(), this.processModel);
        }
        for (LoopbackVehicleModel.Attribute attribute : LoopbackVehicleModel.Attribute.values()) {
            this.processModelChange(attribute.name(), this.processModel);
        }
    }

    private void updateLoopbackVehicleModelData(String attributeChanged, LoopbackVehicleModelTO processModel) {
        if (Objects.equals(attributeChanged, LoopbackVehicleModel.Attribute.OPERATING_TIME.name())) {
            this.updateOperatingTime(processModel.getOperatingTime());
        } else if (Objects.equals(attributeChanged, LoopbackVehicleModel.Attribute.ACCELERATION.name())) {
            this.updateMaxAcceleration(processModel.getMaxAcceleration());
        } else if (Objects.equals(attributeChanged, LoopbackVehicleModel.Attribute.DECELERATION.name())) {
            this.updateMaxDeceleration(processModel.getMaxDeceleration());
        } else if (Objects.equals(attributeChanged, LoopbackVehicleModel.Attribute.MAX_FORWARD_VELOCITY.name())) {
            this.updateMaxForwardVelocity(processModel.getMaxFwdVelocity());
        } else if (Objects.equals(attributeChanged, LoopbackVehicleModel.Attribute.MAX_REVERSE_VELOCITY.name())) {
            this.updateMaxReverseVelocity(processModel.getMaxRevVelocity());
        } else if (Objects.equals(attributeChanged, LoopbackVehicleModel.Attribute.SINGLE_STEP_MODE.name())) {
            this.updateSingleStepMode(processModel.isSingleStepModeEnabled());
        } else if (Objects.equals(attributeChanged, LoopbackVehicleModel.Attribute.VEHICLE_PAUSED.name())) {
            this.updateVehiclePaused(processModel.isVehiclePaused());
        }
    }

    private void updateVehicleProcessModelData(String attributeChanged, VehicleProcessModelTO processModel) {
        if (Objects.equals(attributeChanged, VehicleProcessModel.Attribute.COMM_ADAPTER_ENABLED.name())) {
            this.updateCommAdapterEnabled(processModel.isCommAdapterEnabled());
        } else if (Objects.equals(attributeChanged, VehicleProcessModel.Attribute.POSITION.name())) {
            this.updatePosition(processModel.getPosition());
        } else if (Objects.equals(attributeChanged, VehicleProcessModel.Attribute.STATE.name())) {
            this.updateVehicleState(processModel.getState());
        } else if (Objects.equals(attributeChanged, VehicleProcessModel.Attribute.PRECISE_POSITION.name())) {
            this.updatePrecisePosition(processModel.getPrecisePosition());
        } else if (Objects.equals(attributeChanged, VehicleProcessModel.Attribute.ORIENTATION_ANGLE.name())) {
            this.updateOrientationAngle(processModel.getOrientationAngle());
        } else if (Objects.equals(attributeChanged, VehicleProcessModel.Attribute.ENERGY_LEVEL.name())) {
            this.updateEnergyLevel(processModel.getEnergyLevel());
        } else if (Objects.equals(attributeChanged, VehicleProcessModel.Attribute.LOAD_HANDLING_DEVICES.name())) {
            this.updateVehicleLoadHandlingDevice(processModel.getLoadHandlingDevices());
        }
    }

    private void updateVehicleLoadHandlingDevice(List<LoadHandlingDevice> devices) {
        if (devices.size() > 1) {
            LOG.warn("size of load handling devices greater than 1 ({})", (Object)devices.size());
        }
        boolean loaded = devices.stream().findFirst().map(lhd -> lhd.isFull()).orElse(false);
        SwingUtilities.invokeLater(() -> this.lHDCheckbox.setSelected(loaded));
    }

    private void updateEnergyLevel(int energy) {
        SwingUtilities.invokeLater(() -> this.energyLevelTxt.setText(Integer.toString(energy)));
    }

    private void updateCommAdapterEnabled(boolean isEnabled) {
        SwingUtilities.invokeLater(() -> {
            this.setStatePanelEnabled(isEnabled);
            this.chkBoxEnable.setSelected(isEnabled);
        });
    }

    private void updatePosition(String vehiclePosition) {
        SwingUtilities.invokeLater(() -> {
            if (vehiclePosition == null) {
                this.positionTxt.setText("");
                return;
            }
            try {
                for (Point curPoint : (Set)this.callWrapper.call(() -> this.vehicleService.fetchObjects(Point.class))) {
                    if (!curPoint.getName().equals(vehiclePosition)) continue;
                    this.positionTxt.setText(curPoint.getName());
                    break;
                }
            }
            catch (Exception ex) {
                LOG.warn("Error fetching points", (Throwable)ex);
            }
        });
    }

    private void updateVehicleState(Vehicle.State vehicleState) {
        SwingUtilities.invokeLater(() -> this.stateTxt.setText(vehicleState.toString()));
    }

    private void updatePrecisePosition(Triple precisePos) {
        SwingUtilities.invokeLater(() -> this.setPrecisePosText(precisePos));
    }

    private void updateOrientationAngle(double orientation) {
        SwingUtilities.invokeLater(() -> {
            if (Double.isNaN(orientation)) {
                this.orientationAngleTxt.setText(BUNDLE.getString("loopbackCommAdapterPanel.textField_orientationAngle.angleNotSetPlaceholder"));
            } else {
                this.orientationAngleTxt.setText(Double.toString(orientation));
            }
        });
    }

    private void updateOperatingTime(int defaultOperatingTime) {
        SwingUtilities.invokeLater(() -> this.opTimeTxt.setText(Integer.toString(defaultOperatingTime)));
    }

    private void updateMaxAcceleration(int maxAcceleration) {
        SwingUtilities.invokeLater(() -> this.maxAccelTxt.setText(Integer.toString(maxAcceleration)));
    }

    private void updateMaxDeceleration(int maxDeceleration) {
        SwingUtilities.invokeLater(() -> this.maxDecelTxt.setText(Integer.toString(maxDeceleration)));
    }

    private void updateMaxForwardVelocity(int maxFwdVelocity) {
        SwingUtilities.invokeLater(() -> this.maxFwdVeloTxt.setText(Integer.toString(maxFwdVelocity)));
    }

    private void updateMaxReverseVelocity(int maxRevVelocity) {
        SwingUtilities.invokeLater(() -> this.maxRevVeloTxt.setText(Integer.toString(maxRevVelocity)));
    }

    private void updateSingleStepMode(boolean singleStepMode) {
        SwingUtilities.invokeLater(() -> {
            this.triggerButton.setEnabled(singleStepMode);
            this.singleModeRadioButton.setSelected(singleStepMode);
            this.flowModeRadioButton.setSelected(!singleStepMode);
        });
    }

    private void updateVehiclePaused(boolean isVehiclePaused) {
        SwingUtilities.invokeLater(() -> this.pauseVehicleCheckBox.setSelected(isVehiclePaused));
    }

    private void setStatePanelEnabled(boolean enabled) {
        SwingUtilities.invokeLater(() -> this.positionTxt.setEnabled(enabled));
        SwingUtilities.invokeLater(() -> this.stateTxt.setEnabled(enabled));
        SwingUtilities.invokeLater(() -> this.energyLevelTxt.setEnabled(enabled));
        SwingUtilities.invokeLater(() -> this.precisePosTextArea.setEnabled(enabled));
        SwingUtilities.invokeLater(() -> this.orientationAngleTxt.setEnabled(enabled));
        SwingUtilities.invokeLater(() -> this.pauseVehicleCheckBox.setEnabled(enabled));
    }

    private TCSObjectReference<Vehicle> getVehicleReference() throws Exception {
        return ((Vehicle)this.callWrapper.call(() -> (Vehicle)this.vehicleService.fetchObject(Vehicle.class, this.processModel.getName()))).getReference();
    }

    private void sendCommAdapterCommand(AdapterCommand command) {
        try {
            TCSObjectReference<Vehicle> vehicleRef = this.getVehicleReference();
            this.callWrapper.call(() -> this.vehicleService.sendCommAdapterCommand(vehicleRef, command));
        }
        catch (Exception ex) {
            LOG.warn("Error sending comm adapter command '{}'", (Object)command, (Object)ex);
        }
    }

    private void initComponents() {
        this.modeButtonGroup = new ButtonGroup();
        this.propertyEditorGroup = new ButtonGroup();
        this.vehicleBahaviourPanel = new JPanel();
        this.PropsPowerOuterContainerPanel = new JPanel();
        this.PropsPowerInnerContainerPanel = new JPanel();
        this.vehiclePropsPanel = new JPanel();
        this.maxFwdVeloLbl = new JLabel();
        this.maxFwdVeloTxt = new JTextField();
        this.maxFwdVeloUnitLbl = new JLabel();
        this.maxRevVeloLbl = new JLabel();
        this.maxRevVeloTxt = new JTextField();
        this.maxRevVeloUnitLbl = new JLabel();
        this.maxAccelLbl = new JLabel();
        this.maxAccelTxt = new JTextField();
        this.maxAccelUnitLbl = new JLabel();
        this.maxDecelTxt = new JTextField();
        this.maxDecelLbl = new JLabel();
        this.maxDecelUnitLbl = new JLabel();
        this.defaultOpTimeLbl = new JLabel();
        this.defaultOpTimeUntiLbl = new JLabel();
        this.opTimeTxt = new JTextField();
        this.profilesContainerPanel = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.vehicleStatePanel = new JPanel();
        this.stateContainerPanel = new JPanel();
        this.connectionPanel = new JPanel();
        this.chkBoxEnable = new JCheckBox();
        this.curPosPanel = new JPanel();
        this.energyLevelTxt = new JTextField();
        this.energyLevelLbl = new JLabel();
        this.pauseVehicleCheckBox = new JCheckBox();
        this.orientationAngleLbl = new JLabel();
        this.precisePosUnitLabel = new JLabel();
        this.orientationAngleTxt = new JTextField();
        this.energyLevelLabel = new JLabel();
        this.orientationLabel = new JLabel();
        this.positionTxt = new JTextField();
        this.positionLabel = new JLabel();
        this.pauseVehicleLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.stateTxt = new JTextField();
        this.jLabel3 = new JLabel();
        this.precisePosTextArea = new JTextArea();
        this.propertySetterPanel = new JPanel();
        this.keyLabel = new JLabel();
        this.valueTextField = new JTextField();
        this.propSetButton = new JButton();
        this.removePropRadioBtn = new JRadioButton();
        this.setPropValueRadioBtn = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.keyTextField = new JTextField();
        this.eventPanel = new JPanel();
        this.includeAppendixCheckBox = new JCheckBox();
        this.appendixTxt = new JTextField();
        this.dispatchEventButton = new JButton();
        this.dispatchCommandFailedButton = new JButton();
        this.controlTabPanel = new JPanel();
        this.singleModeRadioButton = new JRadioButton();
        this.flowModeRadioButton = new JRadioButton();
        this.triggerButton = new JButton();
        this.loadDevicePanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lHDCheckbox = new JCheckBox();
        this.setName("LoopbackCommunicationAdapterPanel");
        this.setLayout(new BorderLayout());
        this.vehicleBahaviourPanel.setLayout(new BorderLayout());
        this.PropsPowerOuterContainerPanel.setLayout(new BorderLayout());
        this.PropsPowerInnerContainerPanel.setLayout(new BoxLayout(this.PropsPowerInnerContainerPanel, 0));
        this.vehiclePropsPanel.setBorder(BorderFactory.createTitledBorder(BUNDLE.getString("loopbackCommAdapterPanel.panel_vehicleProperties.border.title")));
        this.vehiclePropsPanel.setLayout(new GridBagLayout());
        this.maxFwdVeloLbl.setHorizontalAlignment(11);
        this.maxFwdVeloLbl.setText(BUNDLE.getString("loopbackCommAdapterPanel.label_maximumForwardVelocity.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxFwdVeloLbl, gridBagConstraints);
        this.maxFwdVeloTxt.setEditable(false);
        this.maxFwdVeloTxt.setColumns(5);
        this.maxFwdVeloTxt.setHorizontalAlignment(4);
        this.maxFwdVeloTxt.setText("0");
        this.maxFwdVeloTxt.setBorder(BorderFactory.createEtchedBorder());
        this.maxFwdVeloTxt.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxFwdVeloTxt, gridBagConstraints);
        this.maxFwdVeloUnitLbl.setText("mm/s");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxFwdVeloUnitLbl, gridBagConstraints);
        this.maxRevVeloLbl.setHorizontalAlignment(11);
        this.maxRevVeloLbl.setText(BUNDLE.getString("loopbackCommAdapterPanel.label_maximumReverseVelocity.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxRevVeloLbl, gridBagConstraints);
        this.maxRevVeloTxt.setEditable(false);
        this.maxRevVeloTxt.setColumns(5);
        this.maxRevVeloTxt.setHorizontalAlignment(4);
        this.maxRevVeloTxt.setText("0");
        this.maxRevVeloTxt.setBorder(BorderFactory.createEtchedBorder());
        this.maxRevVeloTxt.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxRevVeloTxt, gridBagConstraints);
        this.maxRevVeloUnitLbl.setText("mm/s");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxRevVeloUnitLbl, gridBagConstraints);
        this.maxAccelLbl.setHorizontalAlignment(11);
        this.maxAccelLbl.setText(BUNDLE.getString("loopbackCommAdapterPanel.label_maximumAcceleration.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxAccelLbl, gridBagConstraints);
        this.maxAccelTxt.setEditable(false);
        this.maxAccelTxt.setColumns(5);
        this.maxAccelTxt.setHorizontalAlignment(4);
        this.maxAccelTxt.setText("1000");
        this.maxAccelTxt.setBorder(BorderFactory.createEtchedBorder());
        this.maxAccelTxt.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxAccelTxt, gridBagConstraints);
        this.maxAccelUnitLbl.setText("<html>mm/s<sup>2</sup>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxAccelUnitLbl, gridBagConstraints);
        this.maxDecelTxt.setEditable(false);
        this.maxDecelTxt.setColumns(5);
        this.maxDecelTxt.setHorizontalAlignment(4);
        this.maxDecelTxt.setText("1000");
        this.maxDecelTxt.setBorder(BorderFactory.createEtchedBorder());
        this.maxDecelTxt.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxDecelTxt, gridBagConstraints);
        this.maxDecelLbl.setHorizontalAlignment(11);
        this.maxDecelLbl.setText(BUNDLE.getString("loopbackCommAdapterPanel.label_maximumDeceleration.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxDecelLbl, gridBagConstraints);
        this.maxDecelUnitLbl.setText("<html>mm/s<sup>2</sup>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.maxDecelUnitLbl, gridBagConstraints);
        this.defaultOpTimeLbl.setText(BUNDLE.getString("loopbackCommAdapterPanel.label_operatingTime.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.defaultOpTimeLbl, gridBagConstraints);
        this.defaultOpTimeUntiLbl.setText("ms");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.defaultOpTimeUntiLbl, gridBagConstraints);
        this.opTimeTxt.setEditable(false);
        this.opTimeTxt.setColumns(5);
        this.opTimeTxt.setHorizontalAlignment(4);
        this.opTimeTxt.setText("1000");
        this.opTimeTxt.setBorder(BorderFactory.createEtchedBorder());
        this.opTimeTxt.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.vehiclePropsPanel.add((Component)this.opTimeTxt, gridBagConstraints);
        this.PropsPowerInnerContainerPanel.add(this.vehiclePropsPanel);
        this.PropsPowerOuterContainerPanel.add((Component)this.PropsPowerInnerContainerPanel, "West");
        this.vehicleBahaviourPanel.add((Component)this.PropsPowerOuterContainerPanel, "North");
        this.profilesContainerPanel.setLayout(new BorderLayout());
        this.profilesContainerPanel.add((Component)this.filler1, "Center");
        this.vehicleBahaviourPanel.add((Component)this.profilesContainerPanel, "South");
        this.add(this.vehicleBahaviourPanel, "Center");
        this.vehicleStatePanel.setLayout(new BorderLayout());
        this.stateContainerPanel.setLayout(new BoxLayout(this.stateContainerPanel, 1));
        this.connectionPanel.setBorder(BorderFactory.createTitledBorder(BUNDLE.getString("loopbackCommAdapterPanel.panel_adapterStatus.border.title")));
        this.connectionPanel.setName("connectionPanel");
        this.connectionPanel.setLayout(new GridBagLayout());
        this.chkBoxEnable.setText(BUNDLE.getString("loopbackCommAdapterPanel.checkBox_enableAdapter.text"));
        this.chkBoxEnable.setName("chkBoxEnable");
        this.chkBoxEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.chkBoxEnableActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.connectionPanel.add((Component)this.chkBoxEnable, gridBagConstraints);
        this.stateContainerPanel.add(this.connectionPanel);
        this.curPosPanel.setBorder(BorderFactory.createTitledBorder(BUNDLE.getString("loopbackCommAdapterPanel.panel_vehicleStatus.border.title")));
        this.curPosPanel.setName("curPosPanel");
        this.curPosPanel.setLayout(new GridBagLayout());
        this.energyLevelTxt.setEditable(false);
        this.energyLevelTxt.setBackground(new Color(255, 255, 255));
        this.energyLevelTxt.setText("100");
        this.energyLevelTxt.setBorder(BorderFactory.createEtchedBorder());
        this.energyLevelTxt.setName("energyLevelTxt");
        this.energyLevelTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LoopbackCommAdapterPanel.this.energyLevelTxtMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.curPosPanel.add((Component)this.energyLevelTxt, gridBagConstraints);
        this.energyLevelLbl.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.curPosPanel.add((Component)this.energyLevelLbl, gridBagConstraints);
        this.pauseVehicleCheckBox.setEnabled(false);
        this.pauseVehicleCheckBox.setHorizontalAlignment(2);
        this.pauseVehicleCheckBox.setHorizontalTextPosition(10);
        this.pauseVehicleCheckBox.setName("pauseVehicleCheckBox");
        this.pauseVehicleCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LoopbackCommAdapterPanel.this.pauseVehicleCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.curPosPanel.add((Component)this.pauseVehicleCheckBox, gridBagConstraints);
        this.orientationAngleLbl.setText("<html>&#186;");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.curPosPanel.add((Component)this.orientationAngleLbl, gridBagConstraints);
        this.precisePosUnitLabel.setText("mm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.curPosPanel.add((Component)this.precisePosUnitLabel, gridBagConstraints);
        this.orientationAngleTxt.setEditable(false);
        this.orientationAngleTxt.setBackground(new Color(255, 255, 255));
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/commadapter/loopback/Bundle");
        this.orientationAngleTxt.setText(bundle.getString("loopbackCommAdapterPanel.textField_orientationAngle.angleNotSetPlaceholder"));
        this.orientationAngleTxt.setBorder(BorderFactory.createEtchedBorder());
        this.orientationAngleTxt.setName("orientationAngleTxt");
        this.orientationAngleTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LoopbackCommAdapterPanel.this.orientationAngleTxtMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.curPosPanel.add((Component)this.orientationAngleTxt, gridBagConstraints);
        this.energyLevelLabel.setHorizontalAlignment(11);
        this.energyLevelLabel.setText(bundle.getString("loopbackCommAdapterPanel.label_energyLevel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.curPosPanel.add((Component)this.energyLevelLabel, gridBagConstraints);
        this.orientationLabel.setHorizontalAlignment(4);
        this.orientationLabel.setText(bundle.getString("loopbackCommAdapterPanel.label_orientationAngle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.curPosPanel.add((Component)this.orientationLabel, gridBagConstraints);
        this.positionTxt.setEditable(false);
        this.positionTxt.setBackground(new Color(255, 255, 255));
        this.positionTxt.setBorder(BorderFactory.createEtchedBorder());
        this.positionTxt.setName("positionTxt");
        this.positionTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LoopbackCommAdapterPanel.this.positionTxtMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.curPosPanel.add((Component)this.positionTxt, gridBagConstraints);
        this.positionLabel.setHorizontalAlignment(11);
        this.positionLabel.setText(bundle.getString("loopbackCommAdapterPanel.label_position.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.curPosPanel.add((Component)this.positionLabel, gridBagConstraints);
        this.pauseVehicleLabel.setHorizontalAlignment(11);
        this.pauseVehicleLabel.setText(bundle.getString("loopbackCommAdapterPanel.label_pauseVehicle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.curPosPanel.add((Component)this.pauseVehicleLabel, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText(bundle.getString("loopbackCommAdapterPanel.label_state.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.curPosPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.stateTxt.setEditable(false);
        this.stateTxt.setBackground(new Color(255, 255, 255));
        this.stateTxt.setBorder(BorderFactory.createEtchedBorder());
        this.stateTxt.setName("stateTxt");
        this.stateTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LoopbackCommAdapterPanel.this.stateTxtMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.curPosPanel.add((Component)this.stateTxt, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText(bundle.getString("loopbackCommAdapterPanel.label_precisePosition.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.curPosPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.precisePosTextArea.setEditable(false);
        this.precisePosTextArea.setFont(this.positionTxt.getFont());
        this.precisePosTextArea.setRows(3);
        this.precisePosTextArea.setText("X:\nY:\nZ:");
        this.precisePosTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.precisePosTextArea.setName("precisePosTextArea");
        this.precisePosTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LoopbackCommAdapterPanel.this.precisePosTextAreaMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.curPosPanel.add((Component)this.precisePosTextArea, gridBagConstraints);
        this.stateContainerPanel.add(this.curPosPanel);
        this.curPosPanel.getAccessibleContext().setAccessibleName("Change");
        this.propertySetterPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("loopbackCommAdapterPanel.panel_vehicleProperty.border.title")));
        this.propertySetterPanel.setLayout(new GridBagLayout());
        this.keyLabel.setText(bundle.getString("loopbackCommAdapterPanel.label_propertyKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.propertySetterPanel.add((Component)this.keyLabel, gridBagConstraints);
        this.valueTextField.setMaximumSize(new Dimension(4, 18));
        this.valueTextField.setMinimumSize(new Dimension(4, 18));
        this.valueTextField.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.propertySetterPanel.add((Component)this.valueTextField, gridBagConstraints);
        this.propSetButton.setText(bundle.getString("loopbackCommAdapterPanel.button_setProperty.text"));
        this.propSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.propSetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        this.propertySetterPanel.add((Component)this.propSetButton, gridBagConstraints);
        this.propertyEditorGroup.add(this.removePropRadioBtn);
        this.removePropRadioBtn.setText(bundle.getString("loopbackCommAdapterPanel.radioButton_removeProperty.text"));
        this.removePropRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.removePropRadioBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.propertySetterPanel.add((Component)this.removePropRadioBtn, gridBagConstraints);
        this.propertyEditorGroup.add(this.setPropValueRadioBtn);
        this.setPropValueRadioBtn.setSelected(true);
        this.setPropValueRadioBtn.setText(bundle.getString("loopbackCommAdapterPanel.radioButton_setProperty.text"));
        this.setPropValueRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.setPropValueRadioBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.propertySetterPanel.add((Component)this.setPropValueRadioBtn, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.keyTextField.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel3.add((Component)this.keyTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.propertySetterPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.stateContainerPanel.add(this.propertySetterPanel);
        this.eventPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("loopbackCommAdapterPanel.panel_eventDispatching.title")));
        this.eventPanel.setLayout(new GridBagLayout());
        this.includeAppendixCheckBox.setText(bundle.getString("loopbackCommAdapterPanel.checkBox_includeAppendix.text"));
        this.includeAppendixCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LoopbackCommAdapterPanel.this.includeAppendixCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.eventPanel.add((Component)this.includeAppendixCheckBox, gridBagConstraints);
        this.appendixTxt.setEditable(false);
        this.appendixTxt.setColumns(10);
        this.appendixTxt.setText("XYZ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.eventPanel.add((Component)this.appendixTxt, gridBagConstraints);
        this.dispatchEventButton.setText(bundle.getString("loopbackCommAdapterPanel.button_dispatchEvent.text"));
        this.dispatchEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.dispatchEventButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.eventPanel.add((Component)this.dispatchEventButton, gridBagConstraints);
        this.dispatchCommandFailedButton.setText(bundle.getString("loopbackCommAdapterPanel.button_failCurrentCommand.text"));
        this.dispatchCommandFailedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.dispatchCommandFailedButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.eventPanel.add((Component)this.dispatchCommandFailedButton, gridBagConstraints);
        this.stateContainerPanel.add(this.eventPanel);
        this.controlTabPanel.setBorder(BorderFactory.createTitledBorder(BUNDLE.getString("loopbackCommAdapterPanel.panel_commandProcessing.border.title")));
        this.controlTabPanel.setLayout(new GridBagLayout());
        this.modeButtonGroup.add(this.singleModeRadioButton);
        this.singleModeRadioButton.setText(BUNDLE.getString("loopbackCommAdapterPanel.checkBox_commandProcessingManual.text"));
        this.singleModeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.singleModeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.singleModeRadioButton.setName("singleModeRadioButton");
        this.singleModeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.singleModeRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.controlTabPanel.add((Component)this.singleModeRadioButton, gridBagConstraints);
        this.modeButtonGroup.add(this.flowModeRadioButton);
        this.flowModeRadioButton.setSelected(true);
        this.flowModeRadioButton.setText(BUNDLE.getString("loopbackCommAdapterPanel.checkBox_commandProcessingAutomatic.text"));
        this.flowModeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.flowModeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.flowModeRadioButton.setName("flowModeRadioButton");
        this.flowModeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.flowModeRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.controlTabPanel.add((Component)this.flowModeRadioButton, gridBagConstraints);
        this.triggerButton.setText(BUNDLE.getString("loopbackCommAdapterPanel.button_nextStep.text"));
        this.triggerButton.setEnabled(false);
        this.triggerButton.setName("triggerButton");
        this.triggerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.triggerButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.controlTabPanel.add((Component)this.triggerButton, gridBagConstraints);
        this.stateContainerPanel.add(this.controlTabPanel);
        this.vehicleStatePanel.add((Component)this.stateContainerPanel, "North");
        this.loadDevicePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("loopbackCommAdapterPanel.panel_loadHandlingDevice.border.title")));
        this.loadDevicePanel.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.loadDevicePanel.add((Component)this.jPanel1, "South");
        this.lHDCheckbox.setText("Device loaded");
        this.lHDCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoopbackCommAdapterPanel.this.lHDCheckboxClicked(evt);
            }
        });
        this.jPanel2.add(this.lHDCheckbox);
        this.loadDevicePanel.add((Component)this.jPanel2, "West");
        this.vehicleStatePanel.add((Component)this.loadDevicePanel, "Center");
        this.add(this.vehicleStatePanel, "West");
        this.getAccessibleContext().setAccessibleName(bundle.getString("loopbackCommAdapterPanel.accessibleName"));
    }

    private void singleModeRadioButtonActionPerformed(ActionEvent evt) {
        if (this.singleModeRadioButton.isSelected()) {
            this.triggerButton.setEnabled(true);
            this.sendCommAdapterCommand(new SetSingleStepModeEnabledCommand(true));
        }
    }

    private void flowModeRadioButtonActionPerformed(ActionEvent evt) {
        if (this.flowModeRadioButton.isSelected()) {
            this.triggerButton.setEnabled(false);
            this.sendCommAdapterCommand(new SetSingleStepModeEnabledCommand(false));
        }
    }

    private void triggerButtonActionPerformed(ActionEvent evt) {
        this.sendCommAdapterCommand(new TriggerCommand());
    }

    private void chkBoxEnableActionPerformed(ActionEvent evt) {
        try {
            Vehicle vehicle = (Vehicle)this.callWrapper.call(() -> (Vehicle)this.vehicleService.fetchObject(Vehicle.class, this.processModel.getName()));
            if (this.chkBoxEnable.isSelected()) {
                this.callWrapper.call(() -> this.vehicleService.enableCommAdapter(vehicle.getReference()));
            } else {
                this.callWrapper.call(() -> this.vehicleService.disableCommAdapter(vehicle.getReference()));
            }
            this.setStatePanelEnabled(this.chkBoxEnable.isSelected());
        }
        catch (Exception ex) {
            LOG.warn("Error enabling/disabling comm adapter", (Throwable)ex);
        }
    }

    private void precisePosTextAreaMouseClicked(MouseEvent evt) {
        if (this.precisePosTextArea.isEnabled()) {
            Triple pos = this.processModel.getPrecisePosition();
            TripleTextInputPanel.Builder builder = new TripleTextInputPanel.Builder(BUNDLE.getString("loopbackCommAdapterPanel.dialog_setPrecisePosition.title"));
            builder.setUnitLabels("mm");
            builder.setLabels("X:", "Y:", "Z:");
            builder.enableResetButton(null);
            builder.enableValidation("[-+]?[0-9]+");
            if (pos != null) {
                builder.setInitialValues(Long.toString(pos.getX()), Long.toString(pos.getY()), Long.toString(pos.getZ()));
            }
            InputPanel panel = builder.build();
            InputDialog dialog = new InputDialog(panel);
            dialog.setVisible(true);
            if (dialog.getReturnStatus() == InputDialog.ReturnStatus.ACCEPTED) {
                if (dialog.getInput() == null) {
                    this.sendCommAdapterCommand(new SetPrecisePositionCommand(null));
                } else {
                    long z;
                    long y;
                    long x;
                    String[] newPos = (String[])dialog.getInput();
                    try {
                        x = Long.parseLong(newPos[0]);
                        y = Long.parseLong(newPos[1]);
                        z = Long.parseLong(newPos[2]);
                    }
                    catch (NullPointerException | NumberFormatException e) {
                        return;
                    }
                    this.sendCommAdapterCommand(new SetPrecisePositionCommand(new Triple(x, y, z)));
                }
            }
        }
    }

    private void stateTxtMouseClicked(MouseEvent evt) {
        Vehicle.State newState;
        if (!this.stateTxt.isEnabled()) {
            return;
        }
        Vehicle.State currentState = this.processModel.getState();
        InputPanel panel = new DropdownListInputPanel.Builder<Vehicle.State>(BUNDLE.getString("loopbackCommAdapterPanel.dialog_setState.title"), Arrays.asList(Vehicle.State.values())).setSelectionRepresenter(x -> x == null ? "" : x.name()).setLabel(BUNDLE.getString("loopbackCommAdapterPanel.label_state.text")).setInitialSelection(currentState).build();
        InputDialog dialog = new InputDialog(panel);
        dialog.setVisible(true);
        if (dialog.getReturnStatus() == InputDialog.ReturnStatus.ACCEPTED && (newState = (Vehicle.State)dialog.getInput()) != currentState) {
            this.sendCommAdapterCommand(new SetStateCommand(newState));
        }
    }

    private void positionTxtMouseClicked(MouseEvent evt) {
        Set pointSet;
        if (!this.positionTxt.isEnabled()) {
            return;
        }
        try {
            pointSet = (Set)this.callWrapper.call(() -> this.vehicleService.fetchObjects(Point.class));
        }
        catch (Exception ex) {
            LOG.warn("Error fetching points", (Throwable)ex);
            return;
        }
        ArrayList pointList = new ArrayList(pointSet);
        Collections.sort(pointList, Comparators.objectsByName());
        pointList.add(0, null);
        Point currentPoint = null;
        String currentPointName = this.processModel.getPosition();
        for (Point p : pointList) {
            if (p == null || !p.getName().equals(currentPointName)) continue;
            currentPoint = p;
            break;
        }
        InputPanel panel = new DropdownListInputPanel.Builder<Point>(BUNDLE.getString("loopbackCommAdapterPanel.dialog_setPosition.title"), pointList).setSelectionRepresenter(x -> x == null ? "" : x.getName()).setLabel(BUNDLE.getString("loopbackCommAdapterPanel.label_position.text")).setEditable(true).setInitialSelection(currentPoint).setRenderer((ListCellRenderer<Point>)new StringListCellRenderer(x -> x == null ? "" : x.getName())).build();
        InputDialog dialog = new InputDialog(panel);
        dialog.setVisible(true);
        if (dialog.getReturnStatus() == InputDialog.ReturnStatus.ACCEPTED) {
            Object item = dialog.getInput();
            if (item == null) {
                this.sendCommAdapterCommand(new SetPositionCommand(null));
            } else {
                this.sendCommAdapterCommand(new SetPositionCommand(((Point)item).getName()));
            }
        }
    }

    private void orientationAngleTxtMouseClicked(MouseEvent evt) {
        if (!this.orientationAngleTxt.isEnabled()) {
            return;
        }
        double currentAngle = this.processModel.getOrientationAngle();
        String initialValue = Double.isNaN(currentAngle) ? "" : Double.toString(currentAngle);
        InputPanel panel = new SingleTextInputPanel.Builder(BUNDLE.getString("loopbackCommAdapterPanel.dialog_setOrientationAngle.title")).setLabel(BUNDLE.getString("loopbackCommAdapterPanel.label_orientationAngle.text")).setUnitLabel("<html>&#186;").setInitialValue(initialValue).enableResetButton(null).enableValidation("[-+]?[0-9]+(\\.[0-9]+)?").build();
        InputDialog dialog = new InputDialog(panel);
        dialog.setVisible(true);
        InputDialog.ReturnStatus returnStatus = dialog.getReturnStatus();
        if (returnStatus == InputDialog.ReturnStatus.ACCEPTED) {
            String input = (String)dialog.getInput();
            if (input == null) {
                if (!Double.isNaN(this.processModel.getOrientationAngle())) {
                    this.sendCommAdapterCommand(new SetOrientationAngleCommand(Double.NaN));
                }
            } else {
                double angle;
                try {
                    angle = Double.parseDouble(input);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Exception parsing orientation angle value '{}'", (Object)input, (Object)e);
                    return;
                }
                this.sendCommAdapterCommand(new SetOrientationAngleCommand(angle));
            }
        }
    }

    private void pauseVehicleCheckBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.sendCommAdapterCommand(new SetVehiclePausedCommand(true));
        } else if (evt.getStateChange() == 2) {
            this.sendCommAdapterCommand(new SetVehiclePausedCommand(false));
        }
    }

    private void energyLevelTxtMouseClicked(MouseEvent evt) {
        if (!this.energyLevelTxt.isEnabled()) {
            return;
        }
        InputPanel panel = new SingleTextInputPanel.Builder(BUNDLE.getString("loopbackCommAdapterPanel.dialog_setEnergyLevel.title")).setLabel(BUNDLE.getString("loopbackCommAdapterPanel.label_energyLevel.text")).setUnitLabel("%").setInitialValue(this.energyLevelTxt.getText()).enableValidation("[0-9]|[1-9][0-9]|100").build();
        InputDialog dialog = new InputDialog(panel);
        dialog.setVisible(true);
        if (dialog.getReturnStatus() == InputDialog.ReturnStatus.ACCEPTED) {
            int energy;
            String input = (String)dialog.getInput();
            try {
                energy = Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                return;
            }
            this.sendCommAdapterCommand(new SetEnergyLevelCommand(energy));
        }
    }

    private void includeAppendixCheckBoxItemStateChanged(ItemEvent evt) {
        this.appendixTxt.setEditable(this.includeAppendixCheckBox.isSelected());
    }

    private void dispatchEventButtonActionPerformed(ActionEvent evt) {
        String appendix = this.includeAppendixCheckBox.isSelected() ? this.appendixTxt.getText() : null;
        VehicleCommAdapterEvent event = new VehicleCommAdapterEvent(this.processModel.getName(), (Serializable)((Object)appendix));
        this.sendCommAdapterCommand(new PublishEventCommand(event));
    }

    private void dispatchCommandFailedButtonActionPerformed(ActionEvent evt) {
        this.sendCommAdapterCommand(new CurrentMovementCommandFailedCommand());
    }

    private void propSetButtonActionPerformed(ActionEvent evt) {
        this.sendCommAdapterCommand(new SetVehiclePropertyCommand(this.keyTextField.getText(), this.setPropValueRadioBtn.isSelected() ? this.valueTextField.getText() : null));
    }

    private void removePropRadioBtnActionPerformed(ActionEvent evt) {
        this.valueTextField.setEnabled(false);
    }

    private void setPropValueRadioBtnActionPerformed(ActionEvent evt) {
        this.valueTextField.setEnabled(true);
    }

    private void lHDCheckboxClicked(ActionEvent evt) {
        List<LoadHandlingDevice> devices = Arrays.asList(new LoadHandlingDevice("default", this.lHDCheckbox.isSelected()));
        this.sendCommAdapterCommand(new SetLoadHandlingDevicesCommand(devices));
    }

    private void setPrecisePosText(Triple precisePos) {
        String xS = BUNDLE.getString("loopbackCommAdapterPanel.textArea_precisePosition.positionNotSetPlaceholder");
        String yS = BUNDLE.getString("loopbackCommAdapterPanel.textArea_precisePosition.positionNotSetPlaceholder");
        String zS = BUNDLE.getString("loopbackCommAdapterPanel.textArea_precisePosition.positionNotSetPlaceholder");
        if (precisePos != null) {
            xS = String.valueOf(precisePos.getX());
            yS = String.valueOf(precisePos.getY());
            zS = String.valueOf(precisePos.getZ());
        }
        xS = xS.length() > 20 ? xS.substring(0, 20) + "..." : xS;
        yS = yS.length() > 20 ? yS.substring(0, 20) + "..." : yS;
        zS = zS.length() > 20 ? zS.substring(0, 20) + "..." : zS;
        StringBuilder text = new StringBuilder("");
        text.append("X: ").append(xS).append("\n").append("Y: ").append(yS).append("\n").append("Z: ").append(zS);
        this.precisePosTextArea.setText(text.toString());
    }
}

