/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.management.VehicleCommAdapterPanel;
import org.opentcs.drivers.vehicle.management.VehicleCommAdapterPanelFactory;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.virtualvehicle.AdapterPanelComponentsFactory;
import org.opentcs.virtualvehicle.LoopbackCommunicationAdapterDescription;
import org.opentcs.virtualvehicle.LoopbackVehicleModelTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopbackCommAdapterPanelFactory
implements VehicleCommAdapterPanelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LoopbackCommAdapterPanelFactory.class);
    private final KernelServicePortal servicePortal;
    private final AdapterPanelComponentsFactory componentsFactory;
    private boolean initialized;

    @Inject
    public LoopbackCommAdapterPanelFactory(KernelServicePortal servicePortal, AdapterPanelComponentsFactory componentsFactory) {
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.componentsFactory = Objects.requireNonNull(componentsFactory, "componentsFactory");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.initialized = false;
    }

    public List<VehicleCommAdapterPanel> getPanelsFor(@Nonnull VehicleCommAdapterDescription description, @Nonnull TCSObjectReference<Vehicle> vehicle, @Nonnull VehicleProcessModelTO processModel) {
        Objects.requireNonNull(description, "description");
        Objects.requireNonNull(vehicle, "vehicle");
        Objects.requireNonNull(processModel, "processModel");
        if (!this.providesPanelsFor(description, processModel)) {
            return new ArrayList<VehicleCommAdapterPanel>();
        }
        ArrayList<VehicleCommAdapterPanel> panels = new ArrayList<VehicleCommAdapterPanel>();
        panels.add(this.componentsFactory.createPanel((LoopbackVehicleModelTO)processModel, this.servicePortal.getVehicleService()));
        return panels;
    }

    private boolean providesPanelsFor(VehicleCommAdapterDescription description, VehicleProcessModelTO processModel) {
        return description instanceof LoopbackCommunicationAdapterDescription && processModel instanceof LoopbackVehicleModelTO;
    }
}

