/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle;

import com.google.inject.assistedinject.Assisted;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.opentcs.customizations.kernel.KernelExecutor;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.Route;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.drivers.vehicle.BasicVehicleCommAdapter;
import org.opentcs.drivers.vehicle.LoadHandlingDevice;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.drivers.vehicle.SimVehicleCommAdapter;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.util.ExplainedBoolean;
import org.opentcs.virtualvehicle.LoopbackVehicleModel;
import org.opentcs.virtualvehicle.LoopbackVehicleModelTO;
import org.opentcs.virtualvehicle.VelocityController;
import org.opentcs.virtualvehicle.VirtualVehicleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopbackCommunicationAdapter
extends BasicVehicleCommAdapter
implements SimVehicleCommAdapter {
    public static final String LHD_NAME = "default";
    private static final Logger LOG = LoggerFactory.getLogger(LoopbackCommunicationAdapter.class);
    private static final String LOAD_OPERATION_CONFLICT = "cannotLoadWhenLoaded";
    private static final String UNLOAD_OPERATION_CONFLICT = "cannotUnloadWhenNotLoaded";
    private static final int SIMULATION_PERIOD = 100;
    private final VirtualVehicleConfiguration configuration;
    private volatile boolean isSimulationRunning;
    private final Vehicle vehicle;
    private LoadState loadState = LoadState.EMPTY;
    private boolean initialized;

    @Inject
    public LoopbackCommunicationAdapter(VirtualVehicleConfiguration configuration, @Assisted Vehicle vehicle, @KernelExecutor ScheduledExecutorService kernelExecutor) {
        super((VehicleProcessModel)new LoopbackVehicleModel(vehicle), configuration.commandQueueCapacity(), configuration.rechargeOperation(), kernelExecutor);
        this.vehicle = Objects.requireNonNull(vehicle, "vehicle");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        super.initialize();
        String initialPos = (String)this.vehicle.getProperties().get("loopback:initialPosition");
        if (initialPos != null) {
            this.initVehiclePosition(initialPos);
        }
        this.getProcessModel().setState(Vehicle.State.IDLE);
        this.getProcessModel().setLoadHandlingDevices(Arrays.asList(new LoadHandlingDevice(LHD_NAME, false)));
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        super.terminate();
        this.initialized = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (!(evt.getSource() instanceof LoopbackVehicleModel)) {
            return;
        }
        if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.LOAD_HANDLING_DEVICES.name())) {
            if (!this.getProcessModel().getLoadHandlingDevices().isEmpty() && ((LoadHandlingDevice)this.getProcessModel().getLoadHandlingDevices().get(0)).isFull()) {
                this.loadState = LoadState.FULL;
                this.getProcessModel().setLength(this.configuration.vehicleLengthLoaded());
            } else {
                this.loadState = LoadState.EMPTY;
                this.getProcessModel().setLength(this.configuration.vehicleLengthUnloaded());
            }
        }
        if (Objects.equals(evt.getPropertyName(), LoopbackVehicleModel.Attribute.SINGLE_STEP_MODE.name()) && !this.getProcessModel().isSingleStepModeEnabled() && !this.getSentCommands().isEmpty() && !this.isSimulationRunning) {
            this.isSimulationRunning = true;
            ((ExecutorService)this.getExecutor()).submit(() -> this.startVehicleSimulation((MovementCommand)this.getSentCommands().peek()));
        }
    }

    public synchronized void enable() {
        if (this.isEnabled()) {
            return;
        }
        super.enable();
    }

    public synchronized void disable() {
        if (!this.isEnabled()) {
            return;
        }
        super.disable();
    }

    public LoopbackVehicleModel getProcessModel() {
        return (LoopbackVehicleModel)super.getProcessModel();
    }

    public synchronized void sendCommand(MovementCommand cmd) {
        Objects.requireNonNull(cmd, "cmd");
        if (!this.getProcessModel().isSingleStepModeEnabled() && !this.isSimulationRunning) {
            this.isSimulationRunning = true;
            if (this.getSentCommands().isEmpty()) {
                ((ExecutorService)this.getExecutor()).submit(() -> this.startVehicleSimulation(cmd));
            } else {
                ((ExecutorService)this.getExecutor()).submit(() -> this.startVehicleSimulation((MovementCommand)this.getSentCommands().peek()));
            }
        }
    }

    public void onVehiclePaused(boolean paused) {
        this.getProcessModel().setVehiclePaused(paused);
    }

    public void processMessage(Object message) {
    }

    public synchronized void initVehiclePosition(String newPos) {
        ((ExecutorService)this.getExecutor()).submit(() -> this.getProcessModel().setPosition(newPos));
    }

    public synchronized ExplainedBoolean canProcess(TransportOrder order) {
        Objects.requireNonNull(order, "order");
        return this.canProcess(order.getFutureDriveOrders().stream().map(driveOrder -> driveOrder.getDestination().getOperation()).collect(Collectors.toList()));
    }

    @Deprecated
    public synchronized ExplainedBoolean canProcess(List<String> operations) {
        Objects.requireNonNull(operations, "operations");
        LOG.debug("{}: Checking processability of {}...", (Object)this.getName(), operations);
        boolean canProcess = true;
        String reason = "";
        boolean loaded = this.loadState == LoadState.FULL;
        Iterator<String> opIter = operations.iterator();
        while (canProcess && opIter.hasNext()) {
            String nextOp = opIter.next();
            if (loaded) {
                if (nextOp.startsWith(this.getProcessModel().getLoadOperation())) {
                    canProcess = false;
                    reason = LOAD_OPERATION_CONFLICT;
                    continue;
                }
                if (!nextOp.startsWith(this.getProcessModel().getUnloadOperation())) continue;
                loaded = false;
                continue;
            }
            if (nextOp.startsWith(this.getProcessModel().getLoadOperation())) {
                loaded = true;
                continue;
            }
            if (!nextOp.startsWith(this.getProcessModel().getUnloadOperation())) continue;
            canProcess = false;
            reason = UNLOAD_OPERATION_CONFLICT;
        }
        if (!canProcess) {
            LOG.debug("{}: Cannot process {}, reason: '{}'", new Object[]{this.getName(), operations, reason});
        }
        return new ExplainedBoolean(canProcess, reason);
    }

    protected synchronized void connectVehicle() {
    }

    protected synchronized void disconnectVehicle() {
    }

    protected synchronized boolean isVehicleConnected() {
        return true;
    }

    protected VehicleProcessModelTO createCustomTransferableProcessModel() {
        return new LoopbackVehicleModelTO().setLoadOperation(this.getProcessModel().getLoadOperation()).setMaxAcceleration(this.getProcessModel().getMaxAcceleration()).setMaxDeceleration(this.getProcessModel().getMaxDecceleration()).setMaxFwdVelocity(this.getProcessModel().getMaxFwdVelocity()).setMaxRevVelocity(this.getProcessModel().getMaxRevVelocity()).setOperatingTime(this.getProcessModel().getOperatingTime()).setSingleStepModeEnabled(this.getProcessModel().isSingleStepModeEnabled()).setUnloadOperation(this.getProcessModel().getUnloadOperation()).setVehiclePaused(this.getProcessModel().isVehiclePaused());
    }

    public synchronized void trigger() {
        if (this.getProcessModel().isSingleStepModeEnabled() && !this.getSentCommands().isEmpty() && !this.isSimulationRunning) {
            this.isSimulationRunning = true;
            ((ExecutorService)this.getExecutor()).submit(() -> this.startVehicleSimulation((MovementCommand)this.getSentCommands().peek()));
        }
    }

    private void startVehicleSimulation(MovementCommand command) {
        LOG.debug("Starting vehicle simulation for command: {}", (Object)command);
        Route.Step step = command.getStep();
        this.getProcessModel().setState(Vehicle.State.EXECUTING);
        if (step.getPath() == null) {
            LOG.debug("Starting operation simulation...");
            ((ScheduledExecutorService)this.getExecutor()).schedule(() -> this.operationSimulation(command, 0), 100L, TimeUnit.MILLISECONDS);
        } else {
            this.getProcessModel().getVelocityController().addWayEntry(new VelocityController.WayEntry(step.getPath().getLength(), this.maxVelocity(step), step.getDestinationPoint().getName(), step.getVehicleOrientation()));
            LOG.debug("Starting movement simulation...");
            ((ScheduledExecutorService)this.getExecutor()).schedule(() -> this.movementSimulation(command), 100L, TimeUnit.MILLISECONDS);
        }
    }

    private int maxVelocity(Route.Step step) {
        return step.getVehicleOrientation() == Vehicle.Orientation.BACKWARD ? step.getPath().getMaxReverseVelocity() : step.getPath().getMaxVelocity();
    }

    private void movementSimulation(MovementCommand command) {
        if (!this.getProcessModel().getVelocityController().hasWayEntries()) {
            return;
        }
        VelocityController.WayEntry prevWayEntry = this.getProcessModel().getVelocityController().getCurrentWayEntry();
        this.getProcessModel().getVelocityController().advanceTime(this.getSimulationTimeStep());
        VelocityController.WayEntry currentWayEntry = this.getProcessModel().getVelocityController().getCurrentWayEntry();
        if (prevWayEntry == currentWayEntry) {
            ((ScheduledExecutorService)this.getExecutor()).schedule(() -> this.movementSimulation(command), 100L, TimeUnit.MILLISECONDS);
        } else {
            this.getProcessModel().setPosition(prevWayEntry.getDestPointName());
            LOG.debug("Movement simulation finished.");
            if (!command.hasEmptyOperation()) {
                LOG.debug("Starting operation simulation...");
                ((ScheduledExecutorService)this.getExecutor()).schedule(() -> this.operationSimulation(command, 0), 100L, TimeUnit.MILLISECONDS);
            } else {
                this.finishMovementCommand(command);
                this.simulateNextCommand();
            }
        }
    }

    private void operationSimulation(MovementCommand command, int timePassed) {
        if (timePassed < this.getProcessModel().getOperatingTime()) {
            this.getProcessModel().getVelocityController().advanceTime(this.getSimulationTimeStep());
            ((ScheduledExecutorService)this.getExecutor()).schedule(() -> this.operationSimulation(command, timePassed + this.getSimulationTimeStep()), 100L, TimeUnit.MILLISECONDS);
        } else {
            LOG.debug("Operation simulation finished.");
            this.finishMovementCommand(command);
            String operation = command.getOperation();
            if (operation.equals(this.getProcessModel().getLoadOperation())) {
                this.getProcessModel().setLoadHandlingDevices(Arrays.asList(new LoadHandlingDevice(LHD_NAME, true)));
                this.simulateNextCommand();
            } else if (operation.equals(this.getProcessModel().getUnloadOperation())) {
                this.getProcessModel().setLoadHandlingDevices(Arrays.asList(new LoadHandlingDevice(LHD_NAME, false)));
                this.simulateNextCommand();
            } else if (operation.equals(this.getRechargeOperation())) {
                LOG.debug("Starting recharge simulation...");
                this.finishMovementCommand(command);
                this.getProcessModel().setState(Vehicle.State.CHARGING);
                ((ScheduledExecutorService)this.getExecutor()).schedule(() -> this.chargingSimulation(this.getProcessModel().getPosition(), this.getProcessModel().getEnergyLevel()), 100L, TimeUnit.MILLISECONDS);
            } else {
                this.simulateNextCommand();
            }
        }
    }

    private void chargingSimulation(String rechargePosition, float rechargePercentage) {
        if (!this.getSentCommands().isEmpty()) {
            LOG.debug("Aborting recharge operation, vehicle has an order...");
            this.simulateNextCommand();
            return;
        }
        if (this.getProcessModel().getState() != Vehicle.State.CHARGING) {
            LOG.debug("Aborting recharge operation, vehicle no longer charging state...");
            this.simulateNextCommand();
            return;
        }
        if (!Objects.equals(this.getProcessModel().getPosition(), rechargePosition)) {
            LOG.debug("Aborting recharge operation, vehicle position changed...");
            this.simulateNextCommand();
            return;
        }
        if ((double)this.nextChargePercentage(rechargePercentage) < 100.0) {
            this.getProcessModel().setEnergyLevel((int)rechargePercentage);
            ((ScheduledExecutorService)this.getExecutor()).schedule(() -> this.chargingSimulation(rechargePosition, this.nextChargePercentage(rechargePercentage)), 100L, TimeUnit.MILLISECONDS);
        } else {
            LOG.debug("Finishing recharge operation, vehicle at 100%...");
            this.getProcessModel().setEnergyLevel(100);
            this.simulateNextCommand();
        }
    }

    private float nextChargePercentage(float basePercentage) {
        return basePercentage + (float)(this.configuration.rechargePercentagePerSecond() / 1000.0) * 100.0f;
    }

    private void finishMovementCommand(MovementCommand command) {
        if (this.getSentCommands().size() <= 1 && this.getUnsentCommands().isEmpty()) {
            this.getProcessModel().setState(Vehicle.State.IDLE);
        }
        if (Objects.equals(this.getSentCommands().peek(), command)) {
            this.getProcessModel().commandExecuted((MovementCommand)this.getSentCommands().poll());
        } else {
            LOG.warn("{}: Simulated command not oldest in sent queue: {} != {}", new Object[]{this.getName(), command, this.getSentCommands().peek()});
        }
    }

    void simulateNextCommand() {
        if (this.getSentCommands().isEmpty() || this.getProcessModel().isSingleStepModeEnabled()) {
            LOG.debug("Vehicle simulation is done.");
            this.getProcessModel().setState(Vehicle.State.IDLE);
            this.isSimulationRunning = false;
        } else {
            LOG.debug("Triggering simulation for next command: {}", this.getSentCommands().peek());
            ((ExecutorService)this.getExecutor()).submit(() -> this.startVehicleSimulation((MovementCommand)this.getSentCommands().peek()));
        }
    }

    private int getSimulationTimeStep() {
        return (int)(100.0 * this.configuration.simulationTimeFactor());
    }

    private static enum LoadState {
        EMPTY,
        FULL;

    }
}

