/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.VehicleCommAdapterFactory;
import org.opentcs.virtualvehicle.LoopbackAdapterComponentsFactory;
import org.opentcs.virtualvehicle.LoopbackCommunicationAdapter;
import org.opentcs.virtualvehicle.LoopbackCommunicationAdapterDescription;

public class LoopbackCommunicationAdapterFactory
implements VehicleCommAdapterFactory {
    private final LoopbackAdapterComponentsFactory adapterFactory;
    private boolean initialized;

    @Inject
    public LoopbackCommunicationAdapterFactory(LoopbackAdapterComponentsFactory componentsFactory) {
        this.adapterFactory = Objects.requireNonNull(componentsFactory, "componentsFactory");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.initialized = false;
    }

    public VehicleCommAdapterDescription getDescription() {
        return new LoopbackCommunicationAdapterDescription();
    }

    public boolean providesAdapterFor(Vehicle vehicle) {
        Objects.requireNonNull(vehicle, "vehicle");
        return true;
    }

    public LoopbackCommunicationAdapter getAdapterFor(Vehicle vehicle) {
        Objects.requireNonNull(vehicle, "vehicle");
        return this.adapterFactory.createLoopbackCommAdapter(vehicle);
    }
}

