/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle;

import javax.annotation.Nonnull;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.virtualvehicle.Parsers;
import org.opentcs.virtualvehicle.VelocityController;

public class LoopbackVehicleModel
extends VehicleProcessModel {
    private boolean singleStepModeEnabled;
    private final String loadOperation;
    private final String unloadOperation;
    private int operatingTime;
    private final VelocityController velocityController;

    public LoopbackVehicleModel(Vehicle attachedVehicle) {
        super(attachedVehicle);
        this.velocityController = new VelocityController(this.parseDeceleration(attachedVehicle), this.parseAcceleration(attachedVehicle), attachedVehicle.getMaxReverseVelocity(), attachedVehicle.getMaxVelocity());
        this.operatingTime = this.parseOperatingTime(attachedVehicle);
        this.loadOperation = LoopbackVehicleModel.extractLoadOperation(attachedVehicle);
        this.unloadOperation = LoopbackVehicleModel.extractUnloadOperation(attachedVehicle);
    }

    public String getLoadOperation() {
        return this.loadOperation;
    }

    public String getUnloadOperation() {
        return this.unloadOperation;
    }

    public synchronized void setSingleStepModeEnabled(boolean mode) {
        boolean oldValue = this.singleStepModeEnabled;
        this.singleStepModeEnabled = mode;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.SINGLE_STEP_MODE.name(), oldValue, mode);
    }

    public synchronized boolean isSingleStepModeEnabled() {
        return this.singleStepModeEnabled;
    }

    public synchronized int getOperatingTime() {
        return this.operatingTime;
    }

    public synchronized void setOperatingTime(int defaultOperatingTime) {
        int oldValue = this.operatingTime;
        this.operatingTime = defaultOperatingTime;
        this.getPropertyChangeSupport().firePropertyChange(Attribute.OPERATING_TIME.name(), oldValue, defaultOperatingTime);
    }

    public synchronized int getMaxDecceleration() {
        return this.velocityController.getMaxDeceleration();
    }

    public synchronized void setMaxDeceleration(int maxDeceleration) {
        int oldValue = this.velocityController.getMaxDeceleration();
        this.velocityController.setMaxDeceleration(maxDeceleration);
        this.getPropertyChangeSupport().firePropertyChange(Attribute.DECELERATION.name(), oldValue, maxDeceleration);
    }

    public synchronized int getMaxAcceleration() {
        return this.velocityController.getMaxAcceleration();
    }

    public synchronized void setMaxAcceleration(int maxAcceleration) {
        int oldValue = this.velocityController.getMaxAcceleration();
        this.velocityController.setMaxAcceleration(maxAcceleration);
        this.getPropertyChangeSupport().firePropertyChange(Attribute.ACCELERATION.name(), oldValue, maxAcceleration);
    }

    public synchronized int getMaxRevVelocity() {
        return this.velocityController.getMaxRevVelocity();
    }

    public synchronized void setMaxRevVelocity(int maxRevVelocity) {
        int oldValue = this.velocityController.getMaxRevVelocity();
        this.velocityController.setMaxRevVelocity(maxRevVelocity);
        this.getPropertyChangeSupport().firePropertyChange(Attribute.MAX_REVERSE_VELOCITY.name(), oldValue, maxRevVelocity);
    }

    public synchronized int getMaxFwdVelocity() {
        return this.velocityController.getMaxFwdVelocity();
    }

    public synchronized void setMaxFwdVelocity(int maxFwdVelocity) {
        int oldValue = this.velocityController.getMaxFwdVelocity();
        this.velocityController.setMaxFwdVelocity(maxFwdVelocity);
        this.getPropertyChangeSupport().firePropertyChange(Attribute.MAX_FORWARD_VELOCITY.name(), oldValue, maxFwdVelocity);
    }

    public synchronized boolean isVehiclePaused() {
        return this.velocityController.isVehiclePaused();
    }

    public synchronized void setVehiclePaused(boolean pause) {
        boolean oldValue = this.velocityController.isVehiclePaused();
        this.velocityController.setVehiclePaused(pause);
        this.getPropertyChangeSupport().firePropertyChange(Attribute.VEHICLE_PAUSED.name(), oldValue, pause);
    }

    @Nonnull
    public VelocityController getVelocityController() {
        return this.velocityController;
    }

    private int parseOperatingTime(Vehicle vehicle) {
        String opTime = vehicle.getProperty("loopback:operatingTime");
        return Math.max(Parsers.tryParseString(opTime, 5000), 1);
    }

    private int parseAcceleration(Vehicle vehicle) {
        String acceleration = vehicle.getProperty("loopback:acceleration");
        return Math.max(Parsers.tryParseString(acceleration, 500), 1);
    }

    private int parseDeceleration(Vehicle vehicle) {
        String deceleration = vehicle.getProperty("loopback:deceleration");
        return Math.min(Parsers.tryParseString(deceleration, -500), -1);
    }

    private static String extractLoadOperation(Vehicle attachedVehicle) {
        String result = attachedVehicle.getProperty("loopback:loadOperation");
        if (result == null) {
            result = "Load cargo";
        }
        return result;
    }

    private static String extractUnloadOperation(Vehicle attachedVehicle) {
        String result = attachedVehicle.getProperty("loopback:unloadOperation");
        if (result == null) {
            result = "Unload cargo";
        }
        return result;
    }

    public static enum Attribute {
        SINGLE_STEP_MODE,
        OPERATING_TIME,
        ACCELERATION,
        DECELERATION,
        MAX_FORWARD_VELOCITY,
        MAX_REVERSE_VELOCITY,
        VEHICLE_PAUSED;

    }
}

