/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import org.opentcs.data.model.Vehicle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityController {
    private static final Logger LOG = LoggerFactory.getLogger(VelocityController.class);
    private int maxDeceleration;
    private int maxAcceleration;
    private int maxRevVelocity;
    private int maxFwdVelocity;
    private int currentAcceleration;
    private int currentVelocity;
    private int currentPosition;
    private long currentTime;
    private final Queue<WayEntry> wayEntries = new ArrayDeque<WayEntry>();
    private boolean paused;

    public VelocityController(int maxDecel, int maxAccel, int maxRevVelo, int maxFwdVelo) {
        this.maxDeceleration = maxDecel;
        this.maxAcceleration = maxAccel;
        this.maxRevVelocity = maxRevVelo;
        this.maxFwdVelocity = maxFwdVelo;
        this.paused = false;
    }

    public int getMaxDeceleration() {
        return this.maxDeceleration;
    }

    public void setMaxDeceleration(int maxDeceleration) {
        this.maxDeceleration = maxDeceleration;
    }

    public int getMaxAcceleration() {
        return this.maxAcceleration;
    }

    public void setMaxAcceleration(int maxAcceleration) {
        this.maxAcceleration = maxAcceleration;
    }

    public int getMaxRevVelocity() {
        return this.maxRevVelocity;
    }

    public void setMaxRevVelocity(int maxRevVelocity) {
        this.maxRevVelocity = maxRevVelocity;
    }

    public int getMaxFwdVelocity() {
        return this.maxFwdVelocity;
    }

    public void setMaxFwdVelocity(int maxFwdVelocity) {
        this.maxFwdVelocity = maxFwdVelocity;
    }

    public boolean isVehiclePaused() {
        return this.paused;
    }

    public void setVehiclePaused(boolean pause) {
        this.paused = pause;
    }

    public int getCurrentVelocity() {
        return this.currentVelocity;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void addWayEntry(WayEntry newEntry) {
        Objects.requireNonNull(newEntry, "newEntry");
        this.wayEntries.add(newEntry);
    }

    public WayEntry getCurrentWayEntry() {
        return this.wayEntries.peek();
    }

    public boolean hasWayEntries() {
        return !this.wayEntries.isEmpty();
    }

    public void advanceTime(int dt) {
        Preconditions.checkArgument((dt >= 1 ? 1 : 0) != 0, (String)"dt is less than 1: %d", (int)dt);
        int oldPosition = this.currentPosition;
        int oldVelocity = this.currentVelocity;
        WayEntry curWayEntry = this.wayEntries.peek();
        if (curWayEntry == null || this.paused) {
            this.currentAcceleration = 0;
            this.currentVelocity = 0;
        } else {
            int maxVelocity;
            Vehicle.Orientation orientation = curWayEntry.vehicleOrientation;
            switch (orientation) {
                case FORWARD: {
                    maxVelocity = this.maxFwdVelocity;
                    break;
                }
                case BACKWARD: {
                    maxVelocity = this.maxRevVelocity;
                    break;
                }
                default: {
                    LOG.warn("Unhandled orientation: {}, assuming forward.", (Object)orientation);
                    maxVelocity = this.maxFwdVelocity;
                }
            }
            int targetVelocity = Math.min(curWayEntry.targetVelocity, maxVelocity);
            long accelerationDistance = 10L;
            this.currentAcceleration = this.currentVelocity == targetVelocity ? 0 : this.suitableAcceleration(targetVelocity, 10L);
            this.currentVelocity = oldVelocity + this.currentAcceleration * dt / 1000;
            this.currentPosition = oldPosition + oldVelocity * dt / 1000 + this.currentAcceleration * dt * dt / 1000000 / 2;
            if ((long)this.currentPosition >= curWayEntry.length) {
                this.currentPosition = (int)((long)this.currentPosition - curWayEntry.length);
                this.wayEntries.poll();
            }
        }
        this.currentTime += (long)dt;
    }

    int suitableAcceleration(int targetVelocity, long travelDistance) {
        if (travelDistance < 1L) {
            throw new IllegalArgumentException("travelDistance is less than 1");
        }
        double v_current = this.currentVelocity;
        double v_target = targetVelocity;
        double s = travelDistance;
        double t = s / (v_current + (v_target - v_current) / 2.0);
        LOG.debug("t = " + t + "; s = " + s + "; v_current = " + v_current + "; v_target = " + v_target);
        int result = (int)((v_target - v_current) / t);
        LOG.debug("result = " + result);
        if (result > this.maxAcceleration) {
            result = this.maxAcceleration;
        } else if (result < this.maxDeceleration) {
            result = this.maxDeceleration;
        }
        return result;
    }

    public static class WayEntry
    implements Serializable {
        private final long length;
        private final int targetVelocity;
        private final String destPointName;
        private final Vehicle.Orientation vehicleOrientation;

        public WayEntry(long length, int maxVelocity, String destPointName, Vehicle.Orientation orientation) {
            Preconditions.checkArgument((length > 0L ? 1 : 0) != 0, (String)"length is not > 0 but %s", (long)length);
            this.length = length;
            if (maxVelocity < 1) {
                LOG.warn("maxVelocity is zero or negative, setting to 100");
                this.targetVelocity = 100;
            } else {
                this.targetVelocity = maxVelocity;
            }
            this.destPointName = Objects.requireNonNull(destPointName, "destPointName");
            this.vehicleOrientation = Objects.requireNonNull(orientation, "vehicleOrientation");
        }

        public String getDestPointName() {
            return this.destPointName;
        }

        public boolean equals(Object o) {
            if (o instanceof WayEntry) {
                WayEntry other = (WayEntry)o;
                return other.length == this.length && other.targetVelocity == this.targetVelocity && this.destPointName.equals(other.destPointName) && this.vehicleOrientation.equals((Object)other.vehicleOrientation);
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.length ^ this.length >>> 32) ^ this.targetVelocity ^ this.destPointName.hashCode() ^ this.vehicleOrientation.hashCode();
        }
    }
}

