/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle;

import org.opentcs.configuration.ConfigurationEntry;
import org.opentcs.configuration.ConfigurationPrefix;

@ConfigurationPrefix(value="virtualvehicle")
public interface VirtualVehicleConfiguration {
    public static final String PREFIX = "virtualvehicle";

    @ConfigurationEntry(type="Boolean", description={"Whether to enable to register/enable the loopback driver."}, changesApplied=ConfigurationEntry.ChangesApplied.ON_APPLICATION_START, orderKey="0_enable")
    public boolean enable();

    @ConfigurationEntry(type="Integer", description={"The adapter's command queue capacity."}, changesApplied=ConfigurationEntry.ChangesApplied.ON_NEW_PLANT_MODEL, orderKey="1_attributes_1")
    public int commandQueueCapacity();

    @ConfigurationEntry(type="String", description={"The string to be treated as a recharge operation."}, changesApplied=ConfigurationEntry.ChangesApplied.ON_NEW_PLANT_MODEL, orderKey="1_attributes_2")
    public String rechargeOperation();

    @ConfigurationEntry(type="Double", description={"The rate at which the vehicle recharges in percent per second."}, changesApplied=ConfigurationEntry.ChangesApplied.INSTANTLY, orderKey="1_attributes_3")
    public double rechargePercentagePerSecond();

    @ConfigurationEntry(type="Double", description={"The simulation time factor.", "1.0 is real time, greater values speed up simulation."}, changesApplied=ConfigurationEntry.ChangesApplied.INSTANTLY, orderKey="2_behaviour_1")
    public double simulationTimeFactor();

    @ConfigurationEntry(type="Integer", description={"The virtual vehicle's length in mm when it's loaded."}, changesApplied=ConfigurationEntry.ChangesApplied.INSTANTLY, orderKey="2_behaviour_2")
    public int vehicleLengthLoaded();

    @ConfigurationEntry(type="Integer", description={"The virtual vehicle's length in mm when it's unloaded."}, changesApplied=ConfigurationEntry.ChangesApplied.INSTANTLY, orderKey="2_behaviour_3")
    public int vehicleLengthUnloaded();
}

