/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import org.opentcs.virtualvehicle.inputcomponents.EditableComboBoxEditor;
import org.opentcs.virtualvehicle.inputcomponents.InputPanel;

public final class DropdownListInputPanel<E>
extends InputPanel {
    private JComboBox<E> comboBox;
    private JLabel label;
    private JLabel messageLabel;

    private DropdownListInputPanel(String title) {
        super(title);
        this.initComponents();
    }

    @Override
    protected void captureInput() {
        this.input = this.comboBox.isEditable() ? this.comboBox.getEditor().getItem() : this.comboBox.getSelectedItem();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.label = new JLabel();
        this.comboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.messageLabel.setFont(new Font("Arial", 0, 11));
        this.messageLabel.setText("Message");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.messageLabel, gridBagConstraints);
        this.label.setFont(new Font("Arial", 0, 11));
        this.label.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.label, gridBagConstraints);
        this.comboBox.setFont(new Font("Arial", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.comboBox, gridBagConstraints);
    }

    public static class Builder<E>
    implements InputPanel.Builder {
        private final String title;
        private String message;
        private String label;
        private final List<E> content;
        private int initialIndex;
        private boolean editable;
        private ListCellRenderer<? super E> renderer;
        private Function<E, String> selectionRepresenter = o -> o == null ? "" : o.toString();

        public Builder(String title, List<E> content) {
            this.title = Objects.requireNonNull(title, "title");
            this.content = Objects.requireNonNull(content, "content");
        }

        @Override
        public InputPanel build() {
            DropdownListInputPanel panel = new DropdownListInputPanel(this.title);
            panel.messageLabel.setText(this.message);
            panel.label.setText(this.label);
            panel.comboBox.setEditable(this.editable);
            DefaultComboBoxModel<E> model = new DefaultComboBoxModel<E>();
            panel.comboBox.setModel(model);
            if (this.editable) {
                EditableComboBoxEditor editor = new EditableComboBoxEditor(Collections.unmodifiableList(panel.getValidationListeners()), panel.comboBox, this.selectionRepresenter);
                panel.comboBox.setEditor(editor);
                model.addListDataListener(editor);
            }
            for (E c : this.content) {
                model.addElement(c);
            }
            if (this.renderer != null) {
                panel.comboBox.setRenderer(this.renderer);
            }
            if (!this.content.isEmpty()) {
                panel.comboBox.setSelectedIndex(this.initialIndex);
            }
            return panel;
        }

        public Builder<E> setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder<E> setEditable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public Builder<E> setRenderer(ListCellRenderer<? super E> renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder<E> setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder<E> setInitialSelection(int index) {
            if (index >= 0) {
                this.initialIndex = index;
            }
            return this;
        }

        public Builder<E> setInitialSelection(Object element) {
            int index;
            try {
                index = this.content.indexOf(element);
            }
            catch (NullPointerException e) {
                index = -1;
            }
            return this.setInitialSelection(index);
        }

        public Builder<E> setSelectionRepresenter(Function<E, String> selectionRepresenter) {
            this.selectionRepresenter = selectionRepresenter;
            return this;
        }
    }
}

