/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.opentcs.virtualvehicle.inputcomponents.EditableComboBoxListener;
import org.opentcs.virtualvehicle.inputcomponents.ValidationListener;

public class EditableComboBoxEditor<E>
extends BasicComboBoxEditor
implements ListDataListener {
    private final Set<E> content = new HashSet();
    private final JComboBox<E> comboBox;
    private final Function<E, String> representer;

    public EditableComboBoxEditor(List<ValidationListener> validationListeners, JComboBox<E> comboBox, Function<E, String> representer) {
        this.comboBox = Objects.requireNonNull(comboBox, "comboBox");
        this.representer = Objects.requireNonNull(representer, "representer");
        this.editor.getDocument().addDocumentListener(new EditableComboBoxListener<E>(this.content, validationListeners, this.editor, representer));
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.loadContent();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.loadContent();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.loadContent();
    }

    private void loadContent() {
        ComboBoxModel<E> model = this.comboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            this.content.add(model.getElementAt(i));
        }
    }

    @Override
    public Object getItem() {
        for (E p : this.content) {
            if (!this.representer.apply(p).equals(this.editor.getText())) continue;
            return p;
        }
        return null;
    }

    @Override
    public void setItem(Object anObject) {
        this.editor.setText(this.representer.apply(anObject));
    }
}

