/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opentcs.virtualvehicle.inputcomponents.ValidationEvent;
import org.opentcs.virtualvehicle.inputcomponents.ValidationListener;

public class EditableComboBoxListener<E>
implements DocumentListener {
    private final JTextField textField;
    private final List<ValidationListener> validationListeners;
    private final Set<E> content;
    private final Function<E, String> representer;

    public EditableComboBoxListener(Set<E> content, List<ValidationListener> validationListeners, JTextField textField, Function<E, String> representer) {
        this.content = Objects.requireNonNull(content, "content");
        this.validationListeners = Objects.requireNonNull(validationListeners, "validationListeners");
        this.textField = Objects.requireNonNull(textField, "textField");
        this.representer = Objects.requireNonNull(representer, "representer");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validate();
    }

    private void notifyValidationListeners(boolean isValid) {
        for (ValidationListener valListener : this.validationListeners) {
            valListener.validityChanged(new ValidationEvent(this, isValid));
        }
    }

    private void validate() {
        if (this.textField.getText().equals("")) {
            this.notifyValidationListeners(true);
            return;
        }
        for (E element : this.content) {
            if (!this.representer.apply(element).equals(this.textField.getText())) continue;
            this.notifyValidationListeners(true);
            return;
        }
        this.notifyValidationListeners(false);
    }
}

