/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.opentcs.virtualvehicle.inputcomponents.InputPanel;
import org.opentcs.virtualvehicle.inputcomponents.ValidationEvent;
import org.opentcs.virtualvehicle.inputcomponents.ValidationListener;

public class InputDialog
extends JDialog
implements ValidationListener {
    private final InputPanel panel;
    private ReturnStatus returnStatus;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JButton resetButton;

    public InputDialog(InputPanel panel) {
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.panel = panel;
        this.setTitle(panel.getTitle());
        panel.setBorder(new EmptyBorder(6, 6, 10, 6));
        this.getContentPane().add((Component)panel, "Center");
        this.getRootPane().setDefaultButton(this.okButton);
        if (!panel.isResetable()) {
            this.resetButton.setVisible(false);
        }
        this.pack();
        panel.addValidationListener(this);
    }

    @Override
    public void validityChanged(ValidationEvent e) {
        this.okButton.setEnabled(e.valid());
    }

    public ReturnStatus getReturnStatus() {
        return this.returnStatus;
    }

    public Object getInput() {
        return this.panel.getInput();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InputDialog.this.dialogClosing(evt);
            }
        });
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.okButton.setFont(new Font("Arial", 0, 11));
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/commadapter/loopback/Bundle");
        this.okButton.setText(bundle.getString("inputDialog.button_ok.text"));
        this.okButton.setName("inputDialogOkButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setFont(new Font("Arial", 0, 11));
        this.cancelButton.setText(bundle.getString("inputDialog.button_cancel.text"));
        this.cancelButton.setName("inputDialogCancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.resetButton.setFont(new Font("Arial", 0, 11));
        this.resetButton.setText(bundle.getString("inputDialog.button_reset.text"));
        this.resetButton.setName("inputDialogResetButton");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDialog.this.resetButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.resetButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(ReturnStatus.CANCELED);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.panel.captureInput();
        this.doClose(ReturnStatus.ACCEPTED);
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.panel.doReset();
        this.doClose(ReturnStatus.ACCEPTED);
    }

    private void dialogClosing(WindowEvent evt) {
        this.doClose(ReturnStatus.CANCELED);
    }

    private void doClose(ReturnStatus retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static enum ReturnStatus {
        CANCELED,
        ACCEPTED;

    }
}

