/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.opentcs.virtualvehicle.inputcomponents.ValidationEvent;
import org.opentcs.virtualvehicle.inputcomponents.ValidationListener;

public abstract class InputPanel
extends JPanel {
    protected Object input;
    protected boolean resetable;
    private final List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();
    private final String title;
    private boolean inputValid = true;

    public InputPanel(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void addValidationListener(ValidationListener listener) {
        this.validationListeners.add(listener);
        listener.validityChanged(new ValidationEvent(this, this.inputValid));
    }

    protected void setInputValid(boolean valid) {
        boolean changed = valid != this.inputValid;
        this.inputValid = valid;
        if (changed) {
            ValidationEvent e = new ValidationEvent(this, valid);
            for (ValidationListener l : this.validationListeners) {
                l.validityChanged(e);
            }
        }
    }

    public List<ValidationListener> getValidationListeners() {
        return this.validationListeners;
    }

    public boolean isInputValid() {
        return this.inputValid;
    }

    public Object getInput() {
        return this.input;
    }

    protected abstract void captureInput();

    public boolean isResetable() {
        return this.resetable;
    }

    public void doReset() {
    }

    public static interface Builder {
        public InputPanel build();
    }
}

