/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.opentcs.virtualvehicle.inputcomponents.InputPanel;
import org.opentcs.virtualvehicle.inputcomponents.TextInputPanel;

public final class SingleTextInputPanel
extends TextInputPanel {
    private Object resetValue;
    private JTextField inputField;
    private JLabel label;
    private JLabel messageLabel;
    private JLabel unitLabel;

    private SingleTextInputPanel(String title) {
        super(title);
        this.initComponents();
    }

    private void enableInputValidation(String format) {
        if (format != null) {
            this.inputField.getDocument().addDocumentListener(new TextInputPanel.TextInputValidator(format));
        }
    }

    @Override
    protected void captureInput() {
        this.input = this.inputField.getText();
    }

    @Override
    public void doReset() {
        this.input = this.resetValue;
    }

    private void initComponents() {
        this.unitLabel = new JLabel();
        this.label = new JLabel();
        this.inputField = new JTextField();
        this.messageLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.unitLabel.setFont(new Font("Arial", 0, 11));
        this.unitLabel.setHorizontalAlignment(2);
        this.unitLabel.setText("Unit-Label");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.unitLabel, gridBagConstraints);
        this.label.setFont(new Font("Arial", 0, 11));
        this.label.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.label, gridBagConstraints);
        this.inputField.setFont(new Font("Arial", 0, 11));
        this.inputField.setHorizontalAlignment(4);
        this.inputField.setText("initial Value");
        this.inputField.setPreferredSize(new Dimension(70, 20));
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SingleTextInputPanel.this.inputFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.inputField, gridBagConstraints);
        this.messageLabel.setFont(new Font("Arial", 0, 11));
        this.messageLabel.setText("Message");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.messageLabel, gridBagConstraints);
    }

    private void inputFieldFocusGained(FocusEvent evt) {
        this.inputField.selectAll();
    }

    public static class Builder
    implements InputPanel.Builder {
        private final String title;
        private String label;
        private String unitLabel;
        private String initialValue;
        private String message;
        private String format;
        private boolean resetButton;
        private Object resetValue;

        public Builder(String title) {
            this.title = title;
        }

        @Override
        public InputPanel build() {
            SingleTextInputPanel panel = new SingleTextInputPanel(this.title);
            panel.enableInputValidation(this.format);
            panel.label.setText(this.label);
            panel.unitLabel.setText(this.unitLabel);
            panel.inputField.setText(this.initialValue);
            panel.messageLabel.setText(this.message);
            panel.resetable = this.resetButton;
            if (panel.resetable) {
                panel.resetValue = this.resetValue;
            }
            return panel;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setInitialValue(String initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public Builder setUnitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder enableValidation(String format) {
            this.format = format;
            return this;
        }

        public Builder enableResetButton(Object resetValue) {
            this.resetButton = true;
            this.resetValue = resetValue;
            return this;
        }
    }
}

