/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.util.Objects;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.opentcs.virtualvehicle.inputcomponents.InputPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TextInputPanel
extends InputPanel {
    private static final Logger LOG = LoggerFactory.getLogger(TextInputPanel.class);

    public TextInputPanel(String title) {
        super(title);
    }

    protected void setInputValid(boolean valid, Document doc) {
        this.setInputValid(valid);
    }

    public class TextInputValidator
    implements DocumentListener {
        public static final String REGEX_FLOAT = "[-+]?[0-9]+(\\.[0-9]+)?";
        public static final String REGEX_FLOAT_POS = "\\+?[0-9]+(\\.[0-9]+)?";
        public static final String REGEX_FLOAT_NEG = "-[0-9]+(\\.[0-9]+)?|0+(\\.0+)?";
        public static final String REGEX_INT = "[-+]?[0-9]+";
        public static final String REGEX_INT_POS = "\\+?[0-9]+";
        public static final String REGEX_INT_NEG = "-[0-9]+|0+";
        public static final String REGEX_INT_RANGE_0_100 = "[0-9]|[1-9][0-9]|100";
        public static final String REGEX_NOT_EMPTY = ".*\\S.*";
        private final String format;

        protected TextInputValidator(String format) {
            this.format = Objects.requireNonNull(format);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validate(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validate(e.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void validate(Document doc) {
            String text;
            try {
                text = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                LOG.warn("Exception retrieving document text", (Throwable)e);
                return;
            }
            TextInputPanel.this.setInputValid(text.matches(this.format), doc);
        }
    }
}

