/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opentcs.virtualvehicle.inputcomponents.InputPanel;
import org.opentcs.virtualvehicle.inputcomponents.TextInputPanel;

public final class TextListInputPanel
extends TextInputPanel {
    private JTextField inputField;
    private JScrollPane jScrollPane1;
    private JList<String> list;
    private JLabel messageLabel;

    private TextListInputPanel(String title) {
        super(title);
        this.resetable = false;
        this.initComponents();
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selection;
                if (!e.getValueIsAdjusting() && (selection = TextListInputPanel.this.list.getSelectedValue()) != null) {
                    TextListInputPanel.this.inputField.setText(selection);
                }
            }
        });
    }

    @Override
    protected void captureInput() {
        this.input = this.inputField.getText();
    }

    private void enableInputValidation(String format) {
        if (format != null) {
            this.inputField.getDocument().addDocumentListener(new TextInputPanel.TextInputValidator(this, format));
        }
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.inputField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.setLayout(new GridBagLayout());
        this.messageLabel.setFont(new Font("Arial", 0, 11));
        this.messageLabel.setText("Message");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.messageLabel, gridBagConstraints);
        this.inputField.setFont(new Font("Arial", 0, 11));
        this.inputField.setPreferredSize(new Dimension(70, 20));
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TextListInputPanel.this.inputFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.inputField, gridBagConstraints);
        this.list.setFont(new Font("Arial", 0, 11));
        this.list.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void inputFieldFocusGained(FocusEvent evt) {
        this.inputField.selectAll();
    }

    public static class Builder
    implements InputPanel.Builder {
        private final String title;
        private String message;
        private final List<String> content;
        private String format;
        private int initialIndex;

        public Builder(String title, List<String> content) {
            this.title = title;
            this.content = content;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder enableValidation(String format) {
            this.format = format;
            return this;
        }

        public Builder setInitialSelection(int index) {
            if (index >= 0) {
                this.initialIndex = index;
            }
            return this;
        }

        public Builder setInitialSelection(String element) {
            int index;
            try {
                index = this.content.indexOf(element);
            }
            catch (NullPointerException e) {
                index = -1;
            }
            return this.setInitialSelection(index);
        }

        @Override
        public TextListInputPanel build() {
            TextListInputPanel panel = new TextListInputPanel(this.title);
            panel.enableInputValidation(this.format);
            panel.messageLabel.setText(this.message);
            panel.list.setListData((String[])this.content.toArray(new String[this.content.size()]));
            panel.list.setSelectedIndex(this.initialIndex);
            return panel;
        }
    }
}

