/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.virtualvehicle.inputcomponents;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.opentcs.virtualvehicle.inputcomponents.InputPanel;
import org.opentcs.virtualvehicle.inputcomponents.TextInputPanel;

public final class TripleTextInputPanel
extends TextInputPanel {
    private Object resetValue;
    private boolean inputField1Valid = true;
    private boolean inputField2Valid = true;
    private boolean inputField3Valid = true;
    private JTextField inputField1;
    private JTextField inputField2;
    private JTextField inputField3;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel messageLabel;
    private JLabel unitLabel1;
    private JLabel unitLabel2;
    private JLabel unitLabel3;

    private TripleTextInputPanel(String title) {
        super(title);
        this.initComponents();
    }

    private void enableInputValidation(String format1, String format2, String format3) {
        if (format1 != null) {
            this.inputField1.getDocument().addDocumentListener(new TextInputPanel.TextInputValidator(format1));
        }
        if (format2 != null) {
            this.inputField2.getDocument().addDocumentListener(new TextInputPanel.TextInputValidator(format2));
        }
        if (format3 != null) {
            this.inputField3.getDocument().addDocumentListener(new TextInputPanel.TextInputValidator(format3));
        }
    }

    @Override
    protected void captureInput() {
        this.input = new String[]{this.inputField1.getText(), this.inputField2.getText(), this.inputField3.getText()};
    }

    @Override
    public void doReset() {
        this.input = this.resetValue;
    }

    @Override
    protected void setInputValid(boolean valid, Document doc) {
        boolean allValid = valid;
        if (doc == this.inputField1.getDocument()) {
            this.inputField1Valid = valid;
            if (!this.inputField2Valid || !this.inputField3Valid) {
                allValid = false;
            }
        } else if (doc == this.inputField2.getDocument()) {
            this.inputField2Valid = valid;
            if (!this.inputField1Valid || !this.inputField3Valid) {
                allValid = false;
            }
        } else if (doc == this.inputField3.getDocument()) {
            this.inputField3Valid = valid;
            if (!this.inputField1Valid || !this.inputField2Valid) {
                allValid = false;
            }
        } else {
            allValid = false;
        }
        this.setInputValid(allValid);
    }

    private void initComponents() {
        this.unitLabel3 = new JLabel();
        this.label3 = new JLabel();
        this.inputField3 = new JTextField();
        this.messageLabel = new JLabel();
        this.label1 = new JLabel();
        this.inputField1 = new JTextField();
        this.unitLabel1 = new JLabel();
        this.label2 = new JLabel();
        this.inputField2 = new JTextField();
        this.unitLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.unitLabel3.setFont(new Font("Arial", 0, 11));
        this.unitLabel3.setHorizontalAlignment(2);
        this.unitLabel3.setText("Unit-Label");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.unitLabel3, gridBagConstraints);
        this.label3.setFont(new Font("Arial", 0, 11));
        this.label3.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.label3, gridBagConstraints);
        this.inputField3.setFont(new Font("Arial", 0, 11));
        this.inputField3.setHorizontalAlignment(4);
        this.inputField3.setText("initial Value");
        this.inputField3.setName("inputField3");
        this.inputField3.setPreferredSize(new Dimension(70, 20));
        this.inputField3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TripleTextInputPanel.this.inputField3FocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.inputField3, gridBagConstraints);
        this.inputField3.getAccessibleContext().setAccessibleName("");
        this.messageLabel.setFont(new Font("Arial", 0, 11));
        this.messageLabel.setText("Message");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.messageLabel, gridBagConstraints);
        this.label1.setFont(new Font("Arial", 0, 11));
        this.label1.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.label1, gridBagConstraints);
        this.inputField1.setFont(new Font("Arial", 0, 11));
        this.inputField1.setHorizontalAlignment(4);
        this.inputField1.setText("initial Value");
        this.inputField1.setName("inputField1");
        this.inputField1.setPreferredSize(new Dimension(70, 20));
        this.inputField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TripleTextInputPanel.this.inputField1FocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.inputField1, gridBagConstraints);
        this.inputField1.getAccessibleContext().setAccessibleName("");
        this.unitLabel1.setFont(new Font("Arial", 0, 11));
        this.unitLabel1.setHorizontalAlignment(2);
        this.unitLabel1.setText("Unit-Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.unitLabel1, gridBagConstraints);
        this.label2.setFont(new Font("Arial", 0, 11));
        this.label2.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.label2, gridBagConstraints);
        this.inputField2.setFont(new Font("Arial", 0, 11));
        this.inputField2.setHorizontalAlignment(4);
        this.inputField2.setText("initial Value");
        this.inputField2.setName("inputField2");
        this.inputField2.setPreferredSize(new Dimension(70, 20));
        this.inputField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TripleTextInputPanel.this.inputField2FocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.inputField2, gridBagConstraints);
        this.inputField2.getAccessibleContext().setAccessibleName("");
        this.unitLabel2.setFont(new Font("Arial", 0, 11));
        this.unitLabel2.setHorizontalAlignment(2);
        this.unitLabel2.setText("Unit-Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.unitLabel2, gridBagConstraints);
    }

    private void inputField1FocusGained(FocusEvent evt) {
        this.inputField1.selectAll();
    }

    private void inputField2FocusGained(FocusEvent evt) {
        this.inputField2.selectAll();
    }

    private void inputField3FocusGained(FocusEvent evt) {
        this.inputField3.selectAll();
    }

    public static class Builder
    implements InputPanel.Builder {
        private final String title;
        private String message;
        private final String[] labels = new String[3];
        private final String[] unitLabels = new String[3];
        private final String[] initialValues = new String[3];
        private final String[] formats = new String[3];
        private boolean resetButton;
        private Object resetValue;

        public Builder(String title) {
            this.title = title;
        }

        @Override
        public InputPanel build() {
            TripleTextInputPanel panel = new TripleTextInputPanel(this.title);
            panel.enableInputValidation(this.formats[0], this.formats[1], this.formats[2]);
            panel.label1.setText(this.labels[0]);
            panel.label2.setText(this.labels[1]);
            panel.label3.setText(this.labels[2]);
            panel.unitLabel1.setText(this.unitLabels[0]);
            panel.unitLabel2.setText(this.unitLabels[1]);
            panel.unitLabel3.setText(this.unitLabels[2]);
            panel.inputField1.setText(this.initialValues[0]);
            panel.inputField2.setText(this.initialValues[1]);
            panel.inputField3.setText(this.initialValues[2]);
            panel.messageLabel.setText(this.message);
            panel.resetable = this.resetButton;
            if (panel.resetable) {
                panel.resetValue = this.resetValue;
            }
            return panel;
        }

        public Builder setLabels(String label1, String label2, String label3) {
            this.labels[0] = label1;
            this.labels[1] = label2;
            this.labels[2] = label3;
            return this;
        }

        public Builder setInitialValues(String value) {
            return this.setInitialValues(value, value, value);
        }

        public Builder setInitialValues(String val1, String val2, String val3) {
            this.initialValues[0] = val1;
            this.initialValues[1] = val2;
            this.initialValues[2] = val3;
            return this;
        }

        public Builder setUnitLabels(String unit) {
            return this.setUnitLabels(unit, unit, unit);
        }

        public Builder setUnitLabels(String unit1, String unit2, String unit3) {
            this.unitLabels[0] = unit1;
            this.unitLabels[1] = unit2;
            this.unitLabels[2] = unit3;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder enableValidation(String format) {
            return this.enableValidation(format, format, format);
        }

        public Builder enableValidation(String format1, String format2, String format3) {
            this.formats[0] = format1;
            this.formats[1] = format2;
            this.formats[2] = format3;
            return this;
        }

        public Builder enableResetButton(Object resetValue) {
            this.resetButton = true;
            this.resetValue = resetValue;
            return this;
        }
    }
}

