/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.configuration.cfg4j;

import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.environment.Environment;
import org.cfg4j.source.reload.Reloadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedConfigurationSource
implements ConfigurationSource,
Reloadable {
    private static final Logger LOG = LoggerFactory.getLogger(CachedConfigurationSource.class);
    private final ConfigurationSource delegate;
    private final Environment environment;
    private final AtomicReference<Properties> properties = new AtomicReference<Properties>(new Properties());

    public CachedConfigurationSource(ConfigurationSource delegate, Environment environment) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.environment = Objects.requireNonNull(environment, "environment");
    }

    public void reload() {
        try {
            this.delegate.reload();
            this.properties.set(this.delegate.getConfiguration(this.environment));
            LOG.debug("Reloaded properties : {}", this.properties);
        }
        catch (Exception e) {
            LOG.error("Error reloading properties from delegate source : keep old properties", (Throwable)e);
        }
    }

    public Properties getConfiguration(Environment environment) {
        return this.properties.get();
    }

    public void init() {
        this.delegate.init();
        Properties props = this.delegate.getConfiguration(this.environment);
        this.properties.set(props);
    }
}

