/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.configuration.cfg4j;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.ServiceLoader;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.ConfigurationProviderBuilder;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.compose.MergeConfigurationSource;
import org.cfg4j.source.context.environment.DefaultEnvironment;
import org.cfg4j.source.context.environment.Environment;
import org.cfg4j.source.files.FilesConfigurationSource;
import org.cfg4j.source.reload.ReloadStrategy;
import org.opentcs.configuration.ConfigurationBindingProvider;
import org.opentcs.configuration.cfg4j.CachedConfigurationSource;
import org.opentcs.configuration.cfg4j.PeriodicalReloadStrategy;
import org.opentcs.configuration.cfg4j.SupplementaryConfigurationSource;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cfg4jConfigurationBindingProvider
implements ConfigurationBindingProvider {
    private static final Logger LOG = LoggerFactory.getLogger(Cfg4jConfigurationBindingProvider.class);
    private static final String PROPKEY_RELOAD_INTERVAL = "opentcs.cfg4j.reload.interval";
    private static final long DEFAULT_RELOAD_INTERVAL = 10000L;
    private final Path defaultsPath;
    private final Path[] supplementaryPaths;
    private final ConfigurationProvider provider;

    public Cfg4jConfigurationBindingProvider(Path defaultsPath, Path ... supplementaryPaths) {
        this.defaultsPath = Objects.requireNonNull(defaultsPath, "baselineDefaultsPath");
        this.supplementaryPaths = Objects.requireNonNull(supplementaryPaths, "supplementaryPaths");
        this.provider = this.buildProvider();
    }

    public <T> T get(String prefix, Class<T> type) {
        return (T)this.provider.bind(prefix, type);
    }

    private ConfigurationProvider buildProvider() {
        DefaultEnvironment environment = new DefaultEnvironment();
        return new ConfigurationProviderBuilder().withConfigurationSource(this.buildSource((Environment)environment)).withEnvironment((Environment)environment).withReloadStrategy((ReloadStrategy)new PeriodicalReloadStrategy(this.reloadInterval())).build();
    }

    private long reloadInterval() {
        String valueString = System.getProperty(PROPKEY_RELOAD_INTERVAL);
        if (valueString == null) {
            LOG.info("Using default configuration reload interval ({} ms).", (Object)10000L);
            return 10000L;
        }
        try {
            long value = Long.parseLong(valueString);
            LOG.info("Using configuration reload interval of {} ms.", (Object)value);
            return value;
        }
        catch (NumberFormatException exc) {
            LOG.warn("Could not parse '{}', using default configuration reload interval ({} ms).", new Object[]{valueString, 10000L, exc});
            return 10000L;
        }
    }

    private ConfigurationSource buildSource(Environment environment) {
        ArrayList<Object> sources = new ArrayList<Object>();
        Assertions.checkState((boolean)this.defaultsPath.toFile().isFile(), (String)"Required default configuration file {} does not exist.", (Object[])new Object[]{this.defaultsPath.toFile().getAbsolutePath()});
        LOG.info("Using default configuration file {}...", (Object)this.defaultsPath.toFile().getAbsolutePath());
        sources.add(new FilesConfigurationSource(() -> Arrays.asList(this.defaultsPath)));
        for (Path supplementaryPath : this.supplementaryPaths) {
            if (supplementaryPath.toFile().isFile()) {
                LOG.info("Using overrides from supplementary configuration file {}...", (Object)supplementaryPath.toFile().getAbsolutePath());
                sources.add(new FilesConfigurationSource(() -> Arrays.asList(supplementaryPath)));
                continue;
            }
            LOG.warn("Supplementary configuration file {} not found, skipped.", (Object)supplementaryPath.toFile().getAbsolutePath());
        }
        for (ConfigurationSource configurationSource : ServiceLoader.load(SupplementaryConfigurationSource.class)) {
            LOG.info("Using overrides from additional configuration source implementation {}...", configurationSource.getClass());
            sources.add(configurationSource);
        }
        MergeConfigurationSource mergedSource = new MergeConfigurationSource(sources.toArray(new ConfigurationSource[sources.size()]));
        return new CachedConfigurationSource((ConfigurationSource)mergedSource, environment);
    }
}

