/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.configuration.cfg4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cfg4j.source.reload.ReloadStrategy;
import org.cfg4j.source.reload.Reloadable;
import org.opentcs.util.Assertions;
import org.opentcs.util.CyclicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicalReloadStrategy
implements ReloadStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicalReloadStrategy.class);
    private final List<Reloadable> resources = new ArrayList<Reloadable>();
    private final ReloadTask reloadTask;
    private Thread reloadThread;

    public PeriodicalReloadStrategy(long duration) {
        Assertions.checkArgument((duration >= 0L ? 1 : 0) != 0, (String)"duration is %s, has to be => 0", (Object[])new Object[]{duration});
        this.reloadTask = new ReloadTask(duration);
    }

    public void register(Reloadable resource) {
        Objects.requireNonNull(resource, "resource");
        boolean emptyBefore = this.resources.isEmpty();
        if (this.resources.contains(resource)) {
            LOG.debug("Resource {} already registered.", (Object)resource);
            return;
        }
        LOG.debug("Registering resource {}.", (Object)resource);
        this.resources.add(resource);
        if (emptyBefore) {
            this.reloadThread = new Thread((Runnable)((Object)this.reloadTask), this.getClass().getSimpleName() + "-reloadThread");
            this.reloadThread.setDaemon(true);
            this.reloadThread.start();
        }
    }

    public void deregister(Reloadable resource) {
        if (this.resources.remove(resource)) {
            LOG.debug("Deregistered resource {}.", (Object)resource);
        }
        if (this.resources.isEmpty()) {
            this.reloadTask.terminateAndWait();
        }
    }

    private class ReloadTask
    extends CyclicTask {
        ReloadTask(long tSleep) {
            super(tSleep);
        }

        protected void runActualTask() {
            for (Reloadable resource : PeriodicalReloadStrategy.this.resources) {
                resource.reload();
            }
        }
    }
}

