/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.impl.io.PlannerBenchmarkConfigIO;
import org.optaplanner.core.impl.io.OptaPlannerXmlSerializationException;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

class PlannerBenchmarkConfigTest {
    private static final String TEST_PLANNER_BENCHMARK_CONFIG_WITH_NAMESPACE = "testBenchmarkConfigWithNamespace.xml";
    private static final String TEST_PLANNER_BENCHMARK_CONFIG_WITHOUT_NAMESPACE = "testBenchmarkConfigWithoutNamespace.xml";

    PlannerBenchmarkConfigTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"testBenchmarkConfigWithoutNamespace.xml", "testBenchmarkConfigWithNamespace.xml"})
    void xmlConfigFileRemainsSameAfterReadWrite(String xmlBenchmarkConfigResource) throws IOException {
        PlannerBenchmarkConfig jaxbBenchmarkConfig;
        PlannerBenchmarkConfigIO xmlIO = new PlannerBenchmarkConfigIO();
        try (InputStreamReader reader = new InputStreamReader(PlannerBenchmarkConfigTest.class.getResourceAsStream(xmlBenchmarkConfigResource));){
            jaxbBenchmarkConfig = xmlIO.read((Reader)reader);
        }
        Assertions.assertThat((Object)jaxbBenchmarkConfig).isNotNull();
        StringWriter stringWriter = new StringWriter();
        xmlIO.write(jaxbBenchmarkConfig, (Writer)stringWriter);
        String jaxbString = ((Object)stringWriter).toString();
        String originalXml = IOUtils.toString((InputStream)PlannerBenchmarkConfigTest.class.getResourceAsStream(xmlBenchmarkConfigResource), (Charset)StandardCharsets.UTF_8);
        String benchmarkElementWithNamespace = "plannerBenchmark xmlns=\"https://www.optaplanner.org/xsd/benchmark\"";
        if (originalXml.contains(benchmarkElementWithNamespace)) {
            originalXml = originalXml.replace(benchmarkElementWithNamespace, "plannerBenchmark");
        }
        Assertions.assertThat((String)jaxbString).isXmlEqualTo((CharSequence)originalXml);
    }

    @Test
    void readAndValidateInvalidBenchmarkConfig_failsIndicatingTheIssue() {
        PlannerBenchmarkConfigIO xmlIO = new PlannerBenchmarkConfigIO();
        String benchmarkConfigXml = "<plannerBenchmark xmlns=\"https://www.optaplanner.org/xsd/benchmark\">\n  <benchmarkDirectory>data</benchmarkDirectory>\n  <parallelBenchmarkCount>AUTO</parallelBenchmarkCount>\n  <solverBenchmark>\n    <name>Entity Tabu Search</name>\n    <solver>\n      <solutionKlazz>org.optaplanner.core.impl.testdata.domain.TestdataSolution</solutionKlazz>\n      <entityClass>org.optaplanner.core.impl.testdata.domain.TestdataEntity</entityClass>\n    </solver>\n    <problemBenchmarks>\n      <solutionFileIOClass>org.optaplanner.benchmark.config.PlannerBenchmarkConfigTest$TestdataSolutionFileIO</solutionFileIOClass>\n      <inputSolutionFile>nonExistingDataset1.xml</inputSolutionFile>\n    </problemBenchmarks>\n  </solverBenchmark>\n</plannerBenchmark>\n";
        StringReader stringReader = new StringReader(benchmarkConfigXml);
        Assertions.assertThatExceptionOfType(OptaPlannerXmlSerializationException.class).isThrownBy(() -> xmlIO.read((Reader)stringReader)).withMessageContaining("Invalid content was found").withMessageContaining("solutionKlazz");
    }

    private static class TestdataSolutionFileIO
    extends XStreamSolutionFileIO<TestdataSolution> {
        private TestdataSolutionFileIO() {
            super(new Class[]{TestdataSolution.class});
        }
    }
}

