/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.KieSession;
import org.kie.internal.event.rule.RuleEventManager;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.optaplanner.constraint.drl.DrlScoreDirector;
import org.optaplanner.constraint.drl.DrlScoreDirectorFactory;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.buildin.SimpleScoreDefinition;

class DrlScoreDirectorTest {
    DrlScoreDirectorTest() {
    }

    @Test
    void illegalStateExceptionThrownWhenConstraintMatchNotEnabled() {
        DrlScoreDirector director = new DrlScoreDirector(this.mockDroolsScoreDirectorFactory(), false, false);
        director.setWorkingSolution(new Object());
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((DrlScoreDirector)director).getConstraintMatchTotalMap()).withMessageContaining("constraintMatchEnabled");
    }

    @Test
    void constraintMatchTotalsNeverNull() {
        DrlScoreDirector director = new DrlScoreDirector(this.mockDroolsScoreDirectorFactory(), false, true);
        director.setWorkingSolution(new Object());
        Assertions.assertThat((Map)director.getConstraintMatchTotalMap()).isNotNull();
        Assertions.assertThat((Map)director.getConstraintMatchTotalMap()).isNotNull();
    }

    @Test
    void indictmentMapNeverNull() {
        DrlScoreDirector director = new DrlScoreDirector(this.mockDroolsScoreDirectorFactory(), false, true);
        director.setWorkingSolution(new Object());
        Assertions.assertThat((Map)director.getIndictmentMap()).isNotNull();
    }

    private DrlScoreDirectorFactory<Object, SimpleScore> mockDroolsScoreDirectorFactory() {
        DrlScoreDirectorFactory factory = (DrlScoreDirectorFactory)Mockito.mock(DrlScoreDirectorFactory.class);
        Mockito.when((Object)factory.getScoreDefinition()).thenReturn((Object)new SimpleScoreDefinition());
        Mockito.when((Object)factory.getSolutionDescriptor()).thenReturn((Object)((SolutionDescriptor)Mockito.mock(SolutionDescriptor.class)));
        Mockito.when((Object)factory.newKieSession()).thenReturn((Object)((KieSession)Mockito.mock(KieSession.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{RuleEventManager.class}))));
        return factory;
    }
}

