/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.util.Objects;
import java.util.function.Function;
import org.drools.model.Variable;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupBy;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadToBiGroupBy;
import org.optaplanner.core.impl.score.stream.quad.DefaultQuadConstraintCollector;

public class DroolsQuadToBiGroupByAccumulator<A, B, C, D, NewA, NewB>
extends DroolsAbstractGroupByAccumulator<QuadTuple<A, B, C, D>> {
    private final QuadFunction<A, B, C, D, NewA> groupKeyMapping;
    private final QuadConstraintCollector<A, B, C, D, ?, NewB> collector;
    private final Variable<A> aVariable;
    private final Variable<B> bVariable;
    private final Variable<C> cVariable;
    private final Variable<D> dVariable;

    public DroolsQuadToBiGroupByAccumulator(QuadFunction<A, B, C, D, NewA> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ?, NewB> collector, Variable<A> aVariable, Variable<B> bVariable, Variable<C> cVariable, Variable<D> dVariable) {
        this.groupKeyMapping = Objects.requireNonNull(groupKeyMapping);
        this.collector = collector != null ? collector : DefaultQuadConstraintCollector.noop();
        this.aVariable = Objects.requireNonNull(aVariable);
        this.bVariable = Objects.requireNonNull(bVariable);
        this.cVariable = Objects.requireNonNull(cVariable);
        this.dVariable = Objects.requireNonNull(dVariable);
    }

    @Override
    protected DroolsAbstractGroupBy<QuadTuple<A, B, C, D>, ?> newContext() {
        return new DroolsQuadToBiGroupBy<A, B, C, D, NewA, NewB>(this.groupKeyMapping, this.collector);
    }

    @Override
    protected <X> QuadTuple<A, B, C, D> createInput(Function<Variable<X>, X> valueFinder) {
        A a = DroolsQuadToBiGroupByAccumulator.materialize(this.aVariable, valueFinder);
        B b = DroolsQuadToBiGroupByAccumulator.materialize(this.bVariable, valueFinder);
        C c = DroolsQuadToBiGroupByAccumulator.materialize(this.cVariable, valueFinder);
        D d = DroolsQuadToBiGroupByAccumulator.materialize(this.dVariable, valueFinder);
        return new QuadTuple<A, B, C, D>(a, b, c, d);
    }
}

