/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.Agenda;
import org.drools.core.FactException;
import org.drools.core.FactHandle;
import org.drools.core.QueryResults;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.SessionConfiguration;
import org.drools.core.StatefulSession;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.CalendarsImpl;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.InternalViewChangedEventListener;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.base.NonCloningQueryViewListener;
import org.drools.core.base.StandardQueryViewChangedEventListener;
import org.drools.core.common.BaseNode;
import org.drools.core.common.ConcurrentNodeMemories;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EndOperationListener;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.TimedRuleExecution;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.event.AgendaEventListener;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.RuleBaseEventListener;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.event.WorkingMemoryEventListener;
import org.drools.core.event.WorkingMemoryEventSupport;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ObjectMarshallingStrategyStoreImpl;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.ReteooWorkingMemoryInterface;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.Package;
import org.drools.core.rule.Rule;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.core.runtime.process.ProcessRuntimeFactory;
import org.drools.core.runtime.rule.impl.LiveQueryImpl;
import org.drools.core.runtime.rule.impl.OpenQueryViewChangedEventListenerAdapter;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaFilter;
import org.drools.core.spi.AsyncExceptionHandler;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.GlobalResolver;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleBaseUpdateListener;
import org.drools.core.spi.RuleBaseUpdateListenerFactory;
import org.drools.core.time.AcceptsTimerJobFactoryManager;
import org.drools.core.time.TimerService;
import org.drools.core.time.TimerServiceFactory;
import org.drools.core.type.DateFormats;
import org.drools.core.type.DateFormatsImpl;
import org.drools.core.util.LinkedList;
import org.kie.api.KieBase;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessEventManager;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.api.time.SessionClock;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class AbstractWorkingMemory
implements InternalWorkingMemoryActions,
EventSupport,
ProcessEventManager,
CorrelationAwareProcessRuntime,
ReteooWorkingMemoryInterface,
StatefulSession,
Externalizable {
    private static final long serialVersionUID = 510L;
    public byte[] bytes;
    protected int id;
    private NodeMemories nodeMemories;
    protected NamedEntryPoint defaultEntryPoint;
    protected GlobalResolver globalResolver;
    protected Calendars calendars;
    protected DateFormats dateFormats;
    protected WorkingMemoryEventSupport workingMemoryEventSupport;
    protected RuleEventListenerSupport ruleEventListenerSupport;
    protected AgendaEventSupport agendaEventSupport;
    protected List __ruleBaseEventListeners;
    protected transient InternalRuleBase ruleBase;
    protected FactHandleFactory handleFactory;
    protected InternalAgenda agenda;
    private Queue<WorkingMemoryAction> actionQueue;
    protected AtomicBoolean evaluatingActionQueue;
    protected ReentrantLock lock;
    protected AtomicLong propagationIdCounter;
    private boolean sequential;
    protected volatile AtomicBoolean firing;
    private WorkItemManager workItemManager;
    private TimerService timerService;
    protected Map<String, WorkingMemoryEntryPoint> entryPoints;
    protected InternalFactHandle initialFactHandle;
    protected PropagationContextFactory pctxFactory;
    protected SessionConfiguration config;
    private InternalKnowledgeRuntime kruntime;
    private Map<String, Channel> channels;
    private Environment environment;
    private ExecutionResults batchExecutionResult;
    private AtomicLong opCounter;
    private AtomicLong lastIdleTimestamp;
    private InternalProcessRuntime processRuntime;
    private transient ObjectMarshallingStrategyStore marshallingStore;
    private transient List ruleBaseListeners;
    private transient Queue<TimedRuleExecution> timedExecutionsQueue;
    private EndOperationListener endOperationListener;

    public AbstractWorkingMemory() {
    }

    public AbstractWorkingMemory(int id, InternalRuleBase ruleBase) {
        this(id, ruleBase, true, SessionConfiguration.getDefaultInstance(), EnvironmentFactory.newEnvironment());
    }

    public AbstractWorkingMemory(int id, InternalRuleBase ruleBase, boolean initInitFactHandle, SessionConfiguration config, Environment environment) {
        this(id, ruleBase, ruleBase.newFactHandleFactory(), initInitFactHandle, 1L, config, environment, new WorkingMemoryEventSupport(), new AgendaEventSupport(), new RuleEventListenerSupport(), null);
    }

    public AbstractWorkingMemory(int id, InternalRuleBase ruleBase, FactHandleFactory handleFactory, InternalFactHandle initialFactHandle, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        this(id, ruleBase, handleFactory, false, propagationContext, config, environment, new WorkingMemoryEventSupport(), new AgendaEventSupport(), new RuleEventListenerSupport(), agenda);
    }

    public AbstractWorkingMemory(int id, InternalRuleBase ruleBase, FactHandleFactory handleFactory, boolean initInitFactHandle, long propagationContext, SessionConfiguration config, Environment environment, WorkingMemoryEventSupport workingMemoryEventSupport, AgendaEventSupport agendaEventSupport, RuleEventListenerSupport ruleEventListenerSupport, InternalAgenda agenda) {
        this.id = id;
        this.config = config;
        this.ruleBase = ruleBase;
        this.handleFactory = handleFactory;
        this.pctxFactory = ruleBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.environment = environment;
        this.nodeMemories = new ConcurrentNodeMemories(this.ruleBase);
        this.actionQueue = new ConcurrentLinkedQueue<WorkingMemoryAction>();
        Globals globals = (Globals)this.environment.get("org.kie.Globals");
        this.globalResolver = globals != null ? (!(globals instanceof GlobalResolver) ? new GlobalsAdapter(globals) : (GlobalResolver)globals) : new MapGlobalResolver();
        this.calendars = new CalendarsImpl();
        this.dateFormats = (DateFormats)this.environment.get("org.kie.build.DateFormats");
        if (this.dateFormats == null) {
            this.dateFormats = new DateFormatsImpl();
            this.environment.set("org.kie.build.DateFormats", (Object)this.dateFormats);
        }
        RuleBaseConfiguration conf = this.ruleBase.getConfiguration();
        this.sequential = conf.isSequential();
        this.evaluatingActionQueue = new AtomicBoolean(false);
        this.workingMemoryEventSupport = workingMemoryEventSupport;
        this.agendaEventSupport = agendaEventSupport;
        this.ruleEventListenerSupport = ruleEventListenerSupport;
        this.__ruleBaseEventListeners = new java.util.LinkedList();
        this.lock = new ReentrantLock();
        this.timerService = TimerServiceFactory.getTimerService(this.config);
        ((AcceptsTimerJobFactoryManager)((Object)this.timerService)).setTimerJobFactoryManager(config.getTimerJobFactoryManager());
        this.propagationIdCounter = new AtomicLong(propagationContext);
        this.firing = new AtomicBoolean(false);
        this.initTransient();
        this.opCounter = new AtomicLong(0L);
        this.lastIdleTimestamp = new AtomicLong(-1L);
        this.agenda = agenda == null ? ruleBase.getConfiguration().getComponentFactory().getAgendaFactory().createAgenda(ruleBase) : agenda;
        this.agenda.setWorkingMemory(this);
        this.initManagementBeans();
        if (initInitFactHandle) {
            this.initInitialFact(ruleBase, null);
        }
    }

    public void initInitialFact(InternalRuleBase ruleBase, MarshallerReaderContext context) {
        this.initialFactHandle = new DefaultFactHandle(0, InitialFactImpl.getInstance(), 0L, this.defaultEntryPoint);
        ObjectTypeConf otc = this.defaultEntryPoint.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.defaultEntryPoint.entryPoint, this.initialFactHandle.getObject());
        PropagationContextFactory ctxFact = ruleBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        PropagationContext pctx = ctxFact.createPropagationContext(0L, 0, null, null, this.initialFactHandle, this.defaultEntryPoint.getEntryPoint(), context);
        otc.getConcreteObjectTypeNode().assertObject(this.initialFactHandle, pctx, this);
    }

    private void initManagementBeans() {
        if (this.ruleBase.getConfiguration().isMBeansEnabled()) {
            DroolsManagementAgent.getInstance().registerKnowledgeSession(this);
        }
    }

    private InternalProcessRuntime createProcessRuntime() {
        try {
            return ProcessRuntimeFactory.newProcessRuntime(this);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getEntryPointId() {
        return EntryPointId.DEFAULT.getEntryPointId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResults getQueryResults(String queryName, Object[] arguments) {
        try {
            this.startOperation();
            this.ruleBase.readLock();
            this.lock.lock();
            this.ruleBase.executeQueuedActions();
            this.executeQueuedActions();
            DroolsQuery queryObject = new DroolsQuery(queryName, arguments, this.getQueryListenerInstance(), false, null, null, null, null, null);
            InternalFactHandle handle = this.handleFactory.newFactHandle(queryObject, null, this, this);
            PropagationContext pCtx = this.pctxFactory.createPropagationContext(this.getNextPropagationIdCounter(), 0, null, null, handle, this.getEntryPoint());
            BaseNode[] tnodes = this.evalQuery(queryName, queryObject, handle, pCtx);
            ArrayList<Map<String, Declaration>> decls = new ArrayList<Map<String, Declaration>>();
            if (tnodes != null) {
                for (BaseNode node : tnodes) {
                    decls.add(((QueryTerminalNode)node).getSubRule().getOuterDeclarations());
                }
            }
            this.executeQueuedActions();
            this.handleFactory.destroyFactHandle(handle);
            QueryResults queryResults = new QueryResults(queryObject.getQueryResultCollector().getResults(), decls.toArray(new Map[decls.size()]), this, queryObject.getQuery() != null ? queryObject.getQuery().getParameters() : new Declaration[]{});
            return queryResults;
        }
        finally {
            this.lock.unlock();
            this.ruleBase.readUnlock();
            this.endOperation();
        }
    }

    private InternalViewChangedEventListener getQueryListenerInstance() {
        switch (this.config.getQueryListenerOption()) {
            case STANDARD: {
                return new StandardQueryViewChangedEventListener();
            }
            case LIGHTWEIGHT: {
                return new NonCloningQueryViewListener();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        try {
            this.startOperation();
            this.ruleBase.readLock();
            this.lock.lock();
            this.ruleBase.executeQueuedActions();
            this.executeQueuedActions();
            DroolsQuery queryObject = new DroolsQuery(query, arguments, new OpenQueryViewChangedEventListenerAdapter(listener), true, null, null, null, null, null);
            InternalFactHandle handle = this.handleFactory.newFactHandle(queryObject, null, this, this);
            PropagationContext pCtx = this.pctxFactory.createPropagationContext(this.getNextPropagationIdCounter(), 0, null, null, handle, this.getEntryPoint());
            BaseNode[] tnodes = this.evalQuery(queryObject.getName(), queryObject, handle, pCtx);
            this.executeQueuedActions();
            LiveQueryImpl liveQueryImpl = new LiveQueryImpl(this, handle);
            return liveQueryImpl;
        }
        finally {
            this.lock.unlock();
            this.ruleBase.readUnlock();
            this.endOperation();
        }
    }

    private BaseNode[] evalQuery(String queryName, DroolsQuery queryObject, InternalFactHandle handle, PropagationContext pCtx) {
        List<PathMemory> pmems;
        BaseNode[] tnodes = this.ruleBase.getReteooBuilder().getTerminalNodes(queryName);
        if (tnodes == null) {
            throw new RuntimeException("Query '" + queryName + "' does not exist");
        }
        QueryTerminalNode tnode = (QueryTerminalNode)tnodes[0];
        LeftTupleSource lts = tnode.getLeftTupleSource();
        while (lts.getType() != 120) {
            lts = lts.getLeftTupleSource();
        }
        LeftInputAdapterNode lian = (LeftInputAdapterNode)lts;
        LeftInputAdapterNode.LiaNodeMemory lmem = (LeftInputAdapterNode.LiaNodeMemory)this.getNodeMemory((MemoryFactory)((Object)lts));
        SegmentMemory lsmem = lmem.getSegmentMemory();
        if (lsmem == null) {
            lsmem = SegmentUtilities.createSegmentMemory(lts, this);
        }
        if (this.ruleBase.getConfiguration().getEventProcessingMode().equals((Object)EventProcessingOption.STREAM)) {
            PathMemory pmm;
            lmem.linkNode(this);
            pmems = lmem.getSegmentMemory().getPathMemories();
            PathMemory pathMemory = pmm = pmems != null && !pmems.isEmpty() ? pmems.get(0) : null;
            if (pmm != null) {
                RuleAgendaItem item = pmm.getRuleAgendaItem();
                item.getRuleExecutor().reEvaluateNetwork(this, new LinkedList<StackEntry>(), false);
            }
        }
        LeftInputAdapterNode.doInsertObject(handle, pCtx, lian, this, lmem, false, queryObject.isOpen());
        pmems = lmem.getSegmentMemory().getPathMemories();
        int length = pmems.size();
        for (int i = 0; i < length; ++i) {
            PathMemory rm = pmems.get(i);
            RuleAgendaItem evaluator = this.agenda.createRuleAgendaItem(Integer.MAX_VALUE, rm, (TerminalNode)rm.getNetworkNode());
            evaluator.getRuleExecutor().setDirty(true);
            evaluator.getRuleExecutor().evaluateNetworkAndFire(this, null, 0, -1);
        }
        return tnodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeLiveQuery(InternalFactHandle factHandle) {
        try {
            this.startOperation();
            this.ruleBase.readLock();
            this.lock.lock();
            PropagationContext pCtx = this.pctxFactory.createPropagationContext(this.getNextPropagationIdCounter(), 0, null, null, factHandle, this.getEntryPoint());
            LeftInputAdapterNode lian = (LeftInputAdapterNode)factHandle.getFirstLeftTuple().getLeftTupleSink().getLeftTupleSource();
            LeftInputAdapterNode.LiaNodeMemory lmem = (LeftInputAdapterNode.LiaNodeMemory)this.getNodeMemory(lian);
            SegmentMemory lsmem = lmem.getSegmentMemory();
            LeftTuple childLeftTuple = factHandle.getFirstLeftTuple();
            LeftInputAdapterNode.doDeleteObject(childLeftTuple, childLeftTuple.getPropagationContext(), lsmem, this, lian, false, lmem);
            List<PathMemory> pmems = lmem.getSegmentMemory().getPathMemories();
            int length = pmems.size();
            for (int i = 0; i < length; ++i) {
                PathMemory rm = pmems.get(i);
                RuleAgendaItem evaluator = this.agenda.createRuleAgendaItem(Integer.MAX_VALUE, rm, (TerminalNode)rm.getNetworkNode());
                evaluator.getRuleExecutor().setDirty(true);
                evaluator.getRuleExecutor().evaluateNetworkAndFire(this, null, 0, -1);
            }
            this.getFactHandleFactory().destroyFactHandle(factHandle);
        }
        finally {
            this.lock.unlock();
            this.ruleBase.readUnlock();
            this.endOperation();
        }
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.defaultEntryPoint.getEntryPoint();
    }

    @Override
    public InternalWorkingMemory getInternalWorkingMemory() {
        return this;
    }

    public <T extends org.kie.api.runtime.rule.FactHandle> Collection<T> getFactHandles() {
        ArrayList<FactHandle> list = new ArrayList<FactHandle>();
        Iterator it = this.iterateFactHandles();
        while (it.hasNext()) {
            FactHandle fh = (FactHandle)it.next();
            list.add(fh);
        }
        return list;
    }

    public <T extends org.kie.api.runtime.rule.FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        throw new UnsupportedOperationException("this is implementedby StatefulKnowledgeImpl");
    }

    public Collection<? extends Object> getObjects() {
        throw new UnsupportedOperationException("this is implementedby StatefulKnowledgeImpl");
    }

    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        throw new UnsupportedOperationException("this is implementedby StatefulKnowledgeImpl");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)this.getKnowledgeRuntime();
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)ksession.getKieBase(), (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()});
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        marshaller.marshall((OutputStream)stream, (KieSession)((StatefulKnowledgeSession)this.getKnowledgeRuntime()));
        stream.close();
        byte[] bytes = stream.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
    }

    @Override
    public List getRuleBaseUpdateListeners() {
        if (this.ruleBaseListeners == null || this.ruleBaseListeners == Collections.EMPTY_LIST) {
            String listenerName = this.ruleBase.getConfiguration().getRuleBaseUpdateHandler();
            if (listenerName != null && listenerName.length() > 0) {
                RuleBaseUpdateListener listener = RuleBaseUpdateListenerFactory.createListener(listenerName, this);
                this.ruleBaseListeners = Collections.singletonList(listener);
            } else {
                this.ruleBaseListeners = Collections.EMPTY_LIST;
            }
        }
        return this.ruleBaseListeners;
    }

    @Override
    public void updateEntryPointsCache() {
        if (this.ruleBase.getAddedEntryNodeCache() != null) {
            for (EntryPointNode addedNode : this.ruleBase.getAddedEntryNodeCache()) {
                EntryPointId id = addedNode.getEntryPoint();
                if (EntryPointId.DEFAULT.equals(id)) continue;
                NamedEntryPoint wmEntryPoint = new NamedEntryPoint(id, addedNode, this);
                this.entryPoints.put(id.getEntryPointId(), wmEntryPoint);
            }
        }
        if (this.ruleBase.getRemovedEntryNodeCache() != null) {
            for (EntryPointNode removedNode : this.ruleBase.getRemovedEntryNodeCache()) {
                this.entryPoints.remove(removedNode.getEntryPoint().getEntryPointId());
            }
        }
    }

    private void initTransient() {
        EntryPointNode epn = this.ruleBase.getRete().getEntryPointNode(EntryPointId.DEFAULT);
        this.defaultEntryPoint = new NamedEntryPoint(EntryPointId.DEFAULT, epn, this);
        this.entryPoints = new ConcurrentHashMap<String, WorkingMemoryEntryPoint>();
        this.entryPoints.put("DEFAULT", this.defaultEntryPoint);
        this.updateEntryPointsCache();
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.config;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("This should not be called");
    }

    public void reset(int handleId, long handleCounter, long propagationCounter) {
        if (this.nodeMemories != null) {
            this.nodeMemories.clear();
        }
        this.agenda.clear();
        for (WorkingMemoryEntryPoint ep : this.entryPoints.values()) {
            InternalWorkingMemoryEntryPoint iep = (InternalWorkingMemoryEntryPoint)((Object)ep);
            iep.reset();
        }
        this.handleFactory.clear(handleId, handleCounter);
        if (this.actionQueue != null) {
            this.actionQueue.clear();
        }
        this.propagationIdCounter = new AtomicLong(propagationCounter);
        this.opCounter.set(0L);
        this.lastIdleTimestamp.set(-1L);
    }

    @Override
    public void setWorkingMemoryEventSupport(WorkingMemoryEventSupport workingMemoryEventSupport) {
        this.workingMemoryEventSupport = workingMemoryEventSupport;
    }

    @Override
    public void setAgendaEventSupport(AgendaEventSupport agendaEventSupport) {
        this.agendaEventSupport = agendaEventSupport;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    @Override
    public void addEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.removeEventListener(listener);
    }

    @Override
    public List getWorkingMemoryEventListeners() {
        return this.workingMemoryEventSupport.getEventListeners();
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.removeEventListener(listener);
    }

    @Override
    public List getAgendaEventListeners() {
        return this.agendaEventSupport.getEventListeners();
    }

    @Override
    public void addEventListener(RuleBaseEventListener listener) {
        this.ruleBase.addEventListener(listener);
        this.__ruleBaseEventListeners.add(listener);
    }

    public List getRuleBaseEventListeners() {
        return Collections.unmodifiableList(this.__ruleBaseEventListeners);
    }

    @Override
    public void removeEventListener(RuleBaseEventListener listener) {
        this.ruleBase.removeEventListener(listener);
        this.__ruleBaseEventListeners.remove(listener);
    }

    public void addEventListener(ProcessEventListener listener) {
        this.processRuntime.addEventListener(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.processRuntime.getProcessEventListeners();
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.processRuntime.removeEventListener(listener);
    }

    public void addEventListener(RuleEventListener listener) {
        this.ruleEventListenerSupport.addEventListener(listener);
    }

    public void removeEventListener(RuleEventListener listener) {
        this.ruleEventListenerSupport.removeEventListener(listener);
    }

    public List getRuleEventListeners() {
        return this.ruleEventListenerSupport.getEventListeners();
    }

    @Override
    public FactHandleFactory getFactHandleFactory() {
        return this.handleFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobal(String identifier, Object value) {
        if (value == null) {
            return;
        }
        try {
            this.ruleBase.readLock();
            this.startOperation();
            Map<String, Class<?>> globalDefintions = this.ruleBase.getGlobals();
            Class<?> type = globalDefintions.get(identifier);
            if (type == null) {
                throw new RuntimeException("Unexpected global [" + identifier + "]");
            }
            if (!type.isInstance(value)) {
                throw new RuntimeException("Illegal class for global. Expected [" + type.getName() + "], " + "found [" + value.getClass().getName() + "].");
            }
            this.globalResolver.setGlobal(identifier, value);
        }
        finally {
            this.endOperation();
            this.ruleBase.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalResolver(GlobalResolver globalResolver) {
        try {
            this.lock.lock();
            this.globalResolver = globalResolver;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    @Override
    public Calendars getCalendars() {
        return this.calendars;
    }

    @Override
    public DateFormats getDateFormats() {
        return this.dateFormats;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Object getGlobal(String identifier) {
        return this.globalResolver.resolveGlobal(identifier);
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public Agenda getAgenda() {
        return this.agenda;
    }

    @Override
    public void clearAgenda() {
        this.agenda.clearAndCancel();
    }

    @Override
    public void clearAgendaGroup(String group) {
        this.agenda.clearAndCancelAgendaGroup(group);
    }

    @Override
    public void clearActivationGroup(String group) {
        this.agenda.clearAndCancelActivationGroup(group);
    }

    @Override
    public void clearRuleFlowGroup(String group) {
        this.agenda.clearAndCancelRuleFlowGroup(group);
    }

    @Override
    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    @Override
    public void halt() {
        this.agenda.halt();
    }

    @Override
    public int fireAllRules() throws FactException {
        return this.fireAllRules(null, -1);
    }

    @Override
    public int fireAllRules(int fireLimit) throws FactException {
        return this.fireAllRules(null, fireLimit);
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter) throws FactException {
        return this.fireAllRules(agendaFilter, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) throws FactException {
        if (this.firing.compareAndSet(false, true)) {
            try {
                this.startOperation();
                this.ruleBase.readLock();
                this.executeQueuedActions();
                int fireCount = 0;
                int n = fireCount = this.agenda.fireAllRules(agendaFilter, fireLimit);
                return n;
            }
            finally {
                this.ruleBase.readUnlock();
                this.endOperation();
                this.firing.set(false);
            }
        }
        return 0;
    }

    @Override
    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        if (this.isSequential()) {
            throw new IllegalStateException("fireUntilHalt() can not be called in sequential mode.");
        }
        if (this.firing.compareAndSet(false, true)) {
            try {
                AbstractWorkingMemory abstractWorkingMemory = this;
                synchronized (abstractWorkingMemory) {
                    this.executeQueuedActions();
                    this.agenda.fireUntilHalt(agendaFilter);
                }
            }
            finally {
                this.firing.set(false);
            }
        }
    }

    @Override
    public Object getObject(org.kie.api.runtime.rule.FactHandle handle) {
        if (((InternalFactHandle)handle).isDisconnected()) {
            handle = this.defaultEntryPoint.getObjectStore().reconnect(handle);
        }
        return this.defaultEntryPoint.getObject(handle);
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.defaultEntryPoint.getObjectStore();
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        return this.defaultEntryPoint.getFactHandle(object);
    }

    @Override
    public FactHandle getFactHandleByIdentity(Object object) {
        return this.getObjectStore().getHandleForObjectIdentity(object);
    }

    public Iterator iterateObjects() {
        return this.getObjectStore().iterateObjects();
    }

    public Iterator iterateObjects(ObjectFilter filter) {
        return this.getObjectStore().iterateObjects(filter);
    }

    public Iterator iterateFactHandles() {
        return this.getObjectStore().iterateFactHandles();
    }

    public Iterator iterateFactHandles(ObjectFilter filter) {
        return this.getObjectStore().iterateFactHandles(filter);
    }

    public QueryResults getQueryResults(String query) {
        return this.getQueryResults(query, null);
    }

    @Override
    public void setFocus(String focus) {
        this.agenda.setFocus(focus);
    }

    @Override
    public FactHandle insert(Object object) throws FactException {
        return this.insert(object, null, false, false, null, null);
    }

    public FactHandle insertLogical(Object object) throws FactException {
        return this.insert(object, null, false, true, null, null);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) throws FactException {
        return this.insert(object, null, dynamic, false, null, null);
    }

    @Override
    public FactHandle insertLogical(Object object, boolean dynamic) throws FactException {
        return this.insert(object, null, dynamic, true, null, null);
    }

    public FactHandle insertLogical(Object object, Object value) throws FactException {
        return this.insert(object, value, false, true, null, null);
    }

    @Override
    public FactHandle insert(Object object, Object tmsValue, boolean dynamic, boolean logical, Rule rule, Activation activation) throws FactException {
        return this.defaultEntryPoint.insert(object, tmsValue, dynamic, logical, rule, activation);
    }

    @Override
    public void insert(InternalFactHandle handle, Object object, Rule rule, Activation activation, ObjectTypeConf typeConf) {
        this.defaultEntryPoint.insert(handle, object, rule, activation, typeConf, null);
    }

    @Override
    public void retract(org.kie.api.runtime.rule.FactHandle handle) throws FactException {
        this.delete((FactHandle)handle, null, null);
    }

    public void delete(org.kie.api.runtime.rule.FactHandle handle) throws FactException {
        this.delete((FactHandle)handle, null, null);
    }

    @Override
    public void delete(FactHandle factHandle, Rule rule, Activation activation) throws FactException {
        this.defaultEntryPoint.delete(factHandle, rule, activation);
    }

    @Override
    public EntryPointNode getEntryPointNode() {
        return this.defaultEntryPoint.getEntryPointNode();
    }

    @Override
    public void update(org.kie.api.runtime.rule.FactHandle handle, Object object) throws FactException {
        this.update((FactHandle)handle, object, Long.MAX_VALUE, (Class<?>)Object.class, (Activation)null);
    }

    @Override
    public void update(org.kie.api.runtime.rule.FactHandle factHandle, Object object, long mask, Class<?> modifiedClass, Activation activation) throws FactException {
        this.update((FactHandle)factHandle, object, mask, modifiedClass, activation);
    }

    @Override
    public void update(FactHandle factHandle, Object object, long mask, Class<?> modifiedClass, Activation activation) throws FactException {
        this.defaultEntryPoint.update(factHandle, object, mask, modifiedClass, activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeQueuedActions() {
        try {
            this.startOperation();
            if (!this.evaluatingActionQueue.compareAndSet(false, true)) return;
            try {
                if (this.actionQueue == null || this.actionQueue.isEmpty()) return;
                WorkingMemoryAction action = null;
                while ((action = this.actionQueue.poll()) != null) {
                    try {
                        action.execute(this);
                    }
                    catch (Exception e) {
                        throw new RuntimeDroolsException("Unexpected exception executing action " + action.toString(), e);
                        return;
                    }
                }
            }
            finally {
                this.evaluatingActionQueue.compareAndSet(true, false);
            }
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Queue<WorkingMemoryAction> getActionQueue() {
        return this.actionQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueWorkingMemoryAction(WorkingMemoryAction action) {
        try {
            this.startOperation();
            this.getActionQueue().add(action);
            this.agenda.notifyHalt();
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Memory getNodeMemory(MemoryFactory node) {
        return this.nodeMemories.getNodeMemory(node, this);
    }

    @Override
    public void clearNodeMemory(MemoryFactory node) {
        if (this.nodeMemories != null) {
            this.nodeMemories.clearNodeMemory(node);
        }
    }

    @Override
    public NodeMemories getNodeMemories() {
        return this.nodeMemories;
    }

    @Override
    public WorkingMemoryEventSupport getWorkingMemoryEventSupport() {
        return this.workingMemoryEventSupport;
    }

    @Override
    public AgendaEventSupport getAgendaEventSupport() {
        return this.agendaEventSupport;
    }

    @Override
    public void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
    }

    @Override
    public long getNextPropagationIdCounter() {
        return this.propagationIdCounter.incrementAndGet();
    }

    public long getPropagationIdCounter() {
        return this.propagationIdCounter.get();
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public InternalProcessRuntime getProcessRuntime() {
        return this.processRuntime;
    }

    @Override
    public ProcessInstance startProcess(String processId) {
        return this.processRuntime.startProcess(processId);
    }

    @Override
    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.processRuntime.startProcess(processId, parameters);
    }

    @Override
    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.processRuntime.createProcessInstance(processId, parameters);
    }

    @Override
    public ProcessInstance startProcessInstance(long processInstanceId) {
        return this.processRuntime.startProcessInstance(processInstanceId);
    }

    @Override
    public Collection<ProcessInstance> getProcessInstances() {
        return this.processRuntime.getProcessInstances();
    }

    @Override
    public ProcessInstance getProcessInstance(long processInstanceId) {
        return this.processRuntime.getProcessInstance(processInstanceId);
    }

    public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.processRuntime.startProcess(processId, correlationKey, parameters);
    }

    public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.processRuntime.createProcessInstance(processId, correlationKey, parameters);
    }

    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.processRuntime.getProcessInstance(correlationKey);
    }

    @Override
    public ProcessInstance getProcessInstance(long processInstanceId, boolean readOnly) {
        return this.processRuntime.getProcessInstance(processInstanceId, readOnly);
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = this.config.getWorkItemManagerFactory().createWorkItemManager(this.getKnowledgeRuntime());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ksession", this.getKnowledgeRuntime());
            Map<String, WorkItemHandler> workItemHandlers = this.config.getWorkItemHandlers(params);
            if (workItemHandlers != null) {
                for (Map.Entry<String, WorkItemHandler> entry : workItemHandlers.entrySet()) {
                    this.workItemManager.registerWorkItemHandler(entry.getKey(), entry.getValue());
                }
            }
        }
        return this.workItemManager;
    }

    public List iterateObjectsToList() {
        ArrayList result = new ArrayList();
        Iterator iterator = this.iterateObjects();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public List iterateNonDefaultEntryPointObjectsToList() {
        ArrayList<EntryPointObjects> result = new ArrayList<EntryPointObjects>();
        for (Map.Entry<String, WorkingMemoryEntryPoint> entry : this.getEntryPoints().entrySet()) {
            WorkingMemoryEntryPoint entryPoint = entry.getValue();
            if (!(entryPoint instanceof NamedEntryPoint)) continue;
            result.add(new EntryPointObjects(entry.getKey(), new ArrayList(entry.getValue().getObjects())));
        }
        return result;
    }

    public Map.Entry[] getActivationParameters(long activationId) {
        Activation[] activations = this.getAgenda().getActivations();
        for (int i = 0; i < activations.length; ++i) {
            if (activations[i].getActivationNumber() != activationId) continue;
            Map params = this.getActivationParameters(activations[i]);
            return params.entrySet().toArray(new Map.Entry[params.size()]);
        }
        return new Map.Entry[0];
    }

    public Map getActivationParameters(Activation activation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Declaration[] declarations = ((RuleTerminalNode)activation.getTuple().getLeftTupleSink()).getDeclarations();
        for (int i = 0; i < declarations.length; ++i) {
            InternalFactHandle handle = activation.getTuple().get(declarations[i]);
            if (!(handle instanceof InternalFactHandle)) continue;
            result.put(declarations[i].getIdentifier(), declarations[i].getValue(this, handle.getObject()));
        }
        return result;
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        WorkingMemoryEntryPoint wmEntryPoint = this.entryPoints.get(name);
        return wmEntryPoint;
    }

    public Collection<WorkingMemoryEntryPoint> getWorkingMemoryEntryPoints() {
        return this.entryPoints.values();
    }

    @Override
    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.defaultEntryPoint.getObjectTypeConfigurationRegistry();
    }

    @Override
    public InternalFactHandle getInitialFactHandle() {
        return this.initialFactHandle;
    }

    public void setInitialFactHandle(InternalFactHandle initialFactHandle) {
        this.initialFactHandle = initialFactHandle;
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public SessionClock getSessionClock() {
        return (SessionClock)this.timerService;
    }

    @Override
    public void startBatchExecution(ExecutionResultImpl results) {
        this.ruleBase.readLock();
        this.lock.lock();
        this.batchExecutionResult = results;
    }

    @Override
    public ExecutionResultImpl getExecutionResult() {
        return (ExecutionResultImpl)this.batchExecutionResult;
    }

    @Override
    public void endBatchExecution() {
        this.batchExecutionResult = null;
        this.lock.unlock();
        this.ruleBase.readUnlock();
    }

    @Override
    public void dispose() {
        this.ruleBase.disposeStatefulSession(this);
        if (this.ruleBase.getConfiguration().isMBeansEnabled()) {
            DroolsManagementAgent.getInstance().unregisterKnowledgeSession(this);
        }
        for (WorkingMemoryEntryPoint ep : this.entryPoints.values()) {
            ep.dispose();
        }
        this.workingMemoryEventSupport.reset();
        this.agendaEventSupport.reset();
        Iterator it = this.__ruleBaseEventListeners.iterator();
        while (it.hasNext()) {
            this.ruleBase.removeEventListener((RuleBaseEventListener)it.next());
        }
        if (this.processRuntime != null) {
            this.processRuntime.dispose();
        }
        if (this.timerService != null) {
            this.timerService.shutdown();
        }
    }

    @Override
    public void setKnowledgeRuntime(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
        this.processRuntime = this.createProcessRuntime();
    }

    @Override
    public InternalKnowledgeRuntime getKnowledgeRuntime() {
        return this.kruntime;
    }

    @Override
    public void registerChannel(String name, Channel channel) {
        this.getChannels().put(name, channel);
    }

    @Override
    public void unregisterChannel(String name) {
        if (this.channels != null) {
            this.channels.remove(name);
        }
    }

    @Override
    public Map<String, Channel> getChannels() {
        if (this.channels == null) {
            this.channels = new ConcurrentHashMap<String, Channel>();
        }
        return this.channels;
    }

    public Map<String, WorkingMemoryEntryPoint> getEntryPoints() {
        return this.entryPoints;
    }

    public long getFactCount() {
        return this.getObjectStore().size();
    }

    @Override
    public long getTotalFactCount() {
        long result = 0L;
        for (WorkingMemoryEntryPoint ep : this.entryPoints.values()) {
            result += ep.getFactCount();
        }
        return result;
    }

    @Override
    public void startOperation() {
        if (this.opCounter.getAndIncrement() == 0L) {
            this.lastIdleTimestamp.set(-1L);
        }
    }

    @Override
    public void setEndOperationListener(EndOperationListener listener) {
        this.endOperationListener = listener;
    }

    @Override
    public void endOperation() {
        if (this.opCounter.decrementAndGet() == 0L) {
            this.lastIdleTimestamp.set(this.timerService.getCurrentTime());
            if (this.endOperationListener != null) {
                this.endOperationListener.endOperation(this.getKnowledgeRuntime());
            }
        }
    }

    @Override
    public long getIdleTime() {
        long lastIdle = this.lastIdleTimestamp.get();
        return lastIdle > -1L ? this.timerService.getCurrentTime() - lastIdle : -1L;
    }

    @Override
    public long getLastIdleTimestamp() {
        return this.lastIdleTimestamp.get();
    }

    @Override
    public void prepareToFireActivation() {
    }

    @Override
    public void activationFired() {
    }

    @Override
    public long getTimeToNextJob() {
        return this.timerService.getTimeToNextJob();
    }

    public ObjectMarshallingStrategyStore getObjectMarshallingStrategyStore() {
        if (this.marshallingStore == null) {
            this.marshallingStore = new ObjectMarshallingStrategyStoreImpl((ObjectMarshallingStrategy[])this.environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies"));
        }
        return this.marshallingStore;
    }

    @Override
    public Queue<TimedRuleExecution> getTimedExecutionsQueue() {
        return this.timedExecutionsQueue;
    }

    @Override
    public void setTimedExecutionsQueue(Queue<TimedRuleExecution> timedExecutionsQueue) {
        this.timedExecutionsQueue = timedExecutionsQueue;
    }

    private class EntryPointObjects {
        private String name;
        private List objects;

        public EntryPointObjects(String name, List objects) {
            this.name = name;
            this.objects = objects;
        }
    }

    public class RuleFlowDeactivateEvent {
        public void propagate() {
        }
    }

    public static class WorkingMemoryReteExpireAction
    implements WorkingMemoryAction {
        private InternalFactHandle factHandle;
        private ObjectTypeNode node;

        public WorkingMemoryReteExpireAction(InternalFactHandle factHandle, ObjectTypeNode node) {
            this.factHandle = factHandle;
            this.node = node;
        }

        public InternalFactHandle getFactHandle() {
            return this.factHandle;
        }

        public void setFactHandle(InternalFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public ObjectTypeNode getNode() {
            return this.node;
        }

        public void setNode(ObjectTypeNode node) {
            this.node = node;
        }

        public WorkingMemoryReteExpireAction(MarshallerReaderContext context) throws IOException {
            this.factHandle = context.handles.get(context.readInt());
            int nodeId = context.readInt();
            this.node = (ObjectTypeNode)context.sinks.get(nodeId);
        }

        public WorkingMemoryReteExpireAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.factHandle = context.handles.get(_action.getExpire().getHandleId());
            this.node = (ObjectTypeNode)context.sinks.get(_action.getExpire().getNodeId());
        }

        @Override
        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(5);
            context.writeInt(this.factHandle.getId());
            context.writeInt(this.node.getId());
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.EXPIRE).setExpire(ProtobufMessages.ActionQueue.Expire.newBuilder().setHandleId(this.factHandle.getId()).setNodeId(this.node.getId()).build()).build();
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            if (this.factHandle.isValid()) {
                PropagationContextFactory pctxFactory = ((InternalRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getPropagationContextFactory();
                PropagationContext context = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 5, null, null, this.factHandle);
                ((EventFactHandle)this.factHandle).setExpired(true);
                this.node.retractObject(this.factHandle, context, workingMemory);
                context.evaluateActionQueue(workingMemory);
                if (((EventFactHandle)this.factHandle).getActivationsCount() == 0L) {
                    ((EventFactHandle)this.factHandle).getEntryPoint().retract((org.kie.api.runtime.rule.FactHandle)this.factHandle);
                }
                context.evaluateActionQueue(workingMemory);
            }
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }

    public static class WorkingMemoryReteAssertAction
    implements WorkingMemoryAction {
        private InternalFactHandle factHandle;
        private boolean removeLogical;
        private boolean updateEqualsMap;
        private Rule ruleOrigin;
        private LeftTuple leftTuple;

        public WorkingMemoryReteAssertAction(InternalFactHandle factHandle, boolean removeLogical, boolean updateEqualsMap, Rule ruleOrigin, LeftTuple leftTuple) {
            this.factHandle = factHandle;
            this.removeLogical = removeLogical;
            this.updateEqualsMap = updateEqualsMap;
            this.ruleOrigin = ruleOrigin;
            this.leftTuple = leftTuple;
        }

        public WorkingMemoryReteAssertAction(MarshallerReaderContext context) throws IOException {
            this.factHandle = context.handles.get(context.readInt());
            this.removeLogical = context.readBoolean();
            this.updateEqualsMap = context.readBoolean();
            if (context.readBoolean()) {
                String pkgName = context.readUTF();
                String ruleName = context.readUTF();
                Package pkg = context.ruleBase.getPackage(pkgName);
                this.ruleOrigin = pkg.getRule(ruleName);
            }
            if (context.readBoolean()) {
                this.leftTuple = context.terminalTupleMap.get(context.readInt());
            }
        }

        public WorkingMemoryReteAssertAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            ProtobufMessages.ActionQueue.Assert _assert = _action.getAssert();
            this.factHandle = context.handles.get(_assert.getHandleId());
            this.removeLogical = _assert.getRemoveLogical();
            this.updateEqualsMap = _assert.getUpdateEqualsMap();
            if (_assert.hasTuple()) {
                String pkgName = _assert.getOriginPkgName();
                String ruleName = _assert.getOriginRuleName();
                Package pkg = context.ruleBase.getPackage(pkgName);
                this.ruleOrigin = pkg.getRule(ruleName);
                this.leftTuple = context.filter.getTuplesCache().get(PersisterHelper.createActivationKey(pkgName, ruleName, _assert.getTuple()));
            }
        }

        @Override
        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(1);
            context.writeInt(this.factHandle.getId());
            context.writeBoolean(this.removeLogical);
            context.writeBoolean(this.updateEqualsMap);
            if (this.ruleOrigin != null) {
                context.writeBoolean(true);
                context.writeUTF(this.ruleOrigin.getPackage());
                context.writeUTF(this.ruleOrigin.getName());
            } else {
                context.writeBoolean(false);
            }
            if (this.leftTuple != null) {
                context.writeBoolean(true);
                context.writeInt(context.terminalTupleMap.get(this.leftTuple));
            } else {
                context.writeBoolean(false);
            }
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            ProtobufMessages.ActionQueue.Assert.Builder _assert = ProtobufMessages.ActionQueue.Assert.newBuilder();
            _assert.setHandleId(this.factHandle.getId()).setRemoveLogical(this.removeLogical).setUpdateEqualsMap(this.updateEqualsMap);
            if (this.leftTuple != null) {
                ProtobufMessages.Tuple.Builder _tuple = ProtobufMessages.Tuple.newBuilder();
                for (LeftTuple entry = this.leftTuple; entry != null; entry = entry.getParent()) {
                    _tuple.addHandleId(entry.getLastHandle().getId());
                }
                _assert.setOriginPkgName(this.ruleOrigin.getPackageName()).setOriginRuleName(this.ruleOrigin.getName()).setTuple(_tuple.build());
            }
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.ASSERT).setAssert(_assert.build()).build();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.factHandle = (InternalFactHandle)in.readObject();
            this.removeLogical = in.readBoolean();
            this.updateEqualsMap = in.readBoolean();
            this.ruleOrigin = (Rule)in.readObject();
            this.leftTuple = (LeftTuple)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.factHandle);
            out.writeBoolean(this.removeLogical);
            out.writeBoolean(this.updateEqualsMap);
            out.writeObject(this.ruleOrigin);
            out.writeObject(this.leftTuple);
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            PropagationContextFactory pctxFactory = ((InternalRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext context = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 0, this.ruleOrigin, this.leftTuple, this.factHandle);
            ReteooRuleBase ruleBase = (ReteooRuleBase)workingMemory.getRuleBase();
            ruleBase.assertObject(this.factHandle, this.factHandle.getObject(), context, workingMemory);
            context.evaluateActionQueue(workingMemory);
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }

    public static class GlobalsAdapter
    implements GlobalResolver {
        private Globals globals;

        public GlobalsAdapter(Globals globals) {
            this.globals = globals;
        }

        @Override
        public Object resolveGlobal(String identifier) {
            return this.globals.get(identifier);
        }

        @Override
        public void setGlobal(String identifier, Object value) {
            this.globals.set(identifier, value);
        }
    }
}

