/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.DroolsObjectInput;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Package;

public class DroolsObjectInputStream
extends ObjectInputStream
implements DroolsObjectInput {
    private static final Map<String, Class> primClasses = new HashMap<String, Class>(8, 1.0f);
    private ClassLoader parentClassLoader;
    private ClassLoader classLoader;
    private InternalRuleBase ruleBase;
    private InternalWorkingMemory workingMemory;
    private Package pkg;

    public DroolsObjectInputStream(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public DroolsObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
        this.parentClassLoader = classLoader;
    }

    protected Class resolveClass(String className) throws ClassNotFoundException {
        Class<?> clazz = primClasses.get(className);
        if (clazz == null) {
            clazz = Class.forName(className, true, this.classLoader);
        }
        return clazz;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.resolveClass(desc.getName());
    }

    public static InvalidClassException newInvalidClassException(Class clazz, Throwable cause) {
        InvalidClassException exception = new InvalidClassException(clazz.getName());
        exception.initCause(cause);
        return exception;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public InternalRuleBase getRuleBase() {
        return this.ruleBase;
    }

    @Override
    public void setRuleBase(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.classLoader = this.ruleBase.getRootClassLoader();
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    @Override
    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

