/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.RightTupleSets;
import org.drools.core.reteoo.RightTuple;

public class RightTupleSetsImpl
implements RightTupleSets {
    protected RightTuple insertFirst;
    protected volatile int insertSize;
    protected RightTuple deleteFirst;
    protected volatile int deleteSize;
    protected RightTuple updateFirst;
    protected volatile int updateSize;

    @Override
    public RightTuple getInsertFirst() {
        return this.insertFirst;
    }

    @Override
    public RightTuple getDeleteFirst() {
        return this.deleteFirst;
    }

    @Override
    public RightTuple getUpdateFirst() {
        return this.updateFirst;
    }

    public void resetInsert() {
        this.insertFirst = null;
        this.insertSize = 0;
    }

    public void resetDelete() {
        this.deleteFirst = null;
        this.deleteSize = 0;
    }

    public void resetUpdate() {
        this.updateFirst = null;
        this.updateSize = 0;
    }

    @Override
    public void resetAll() {
        this.resetInsert();
        this.resetDelete();
        this.resetUpdate();
    }

    @Override
    public int insertSize() {
        return this.insertSize;
    }

    @Override
    public int deleteSize() {
        return this.insertSize;
    }

    @Override
    public int updateSize() {
        return this.updateSize;
    }

    @Override
    public boolean addInsert(RightTuple rightTuple) {
        rightTuple.setStagedType((short)1);
        if (this.insertFirst == null) {
            this.insertFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.insertFirst);
            this.insertFirst.setStagePrevious(rightTuple);
            this.insertFirst = rightTuple;
        }
        return this.insertSize++ == 0;
    }

    @Override
    public boolean addDelete(RightTuple rightTuple) {
        switch (rightTuple.getStagedType()) {
            case 1: {
                this.removeInsert(rightTuple);
                break;
            }
            case 2: {
                this.removeUpdate(rightTuple);
            }
        }
        rightTuple.setStagedType((short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.deleteFirst);
            this.deleteFirst.setStagePrevious(rightTuple);
            this.deleteFirst = rightTuple;
        }
        return this.deleteSize++ == 0;
    }

    @Override
    public boolean addUpdate(RightTuple rightTuple) {
        if (rightTuple.getStagedType() != 0) {
            return false;
        }
        rightTuple.setStagedType((short)2);
        if (this.updateFirst == null) {
            this.updateFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.updateFirst);
            this.updateFirst.setStagePrevious(rightTuple);
            this.updateFirst = rightTuple;
        }
        return this.updateSize++ == 0;
    }

    public void removeInsert(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.insertFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.insertFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        rightTuple.clearStaged();
    }

    public void removeDelete(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.deleteFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.deleteFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        rightTuple.clearStaged();
    }

    public void removeUpdate(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.updateFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.updateFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        rightTuple.clearStaged();
    }

    public void addAllInserts(RightTupleSets tupleSets) {
        RightTupleSetsImpl tupleSetsImpl = (RightTupleSetsImpl)tupleSets;
        if (this.insertFirst == null) {
            this.insertFirst = tupleSetsImpl.getInsertFirst();
            this.insertSize = tupleSetsImpl.insertSize;
        } else {
            RightTuple last = null;
            for (RightTuple current = this.insertFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            RightTuple rightTuple = tupleSetsImpl.getInsertFirst();
            last.setStagedNext(rightTuple);
            rightTuple.setStagePrevious(rightTuple);
            this.insertSize += tupleSetsImpl.insertSize();
        }
    }

    public void addAllDeletes(RightTupleSets tupleSets) {
        RightTupleSetsImpl tupleSetsImpl = (RightTupleSetsImpl)tupleSets;
        if (this.deleteFirst == null) {
            this.deleteFirst = tupleSetsImpl.getDeleteFirst();
            this.deleteSize = tupleSetsImpl.deleteSize;
        } else {
            RightTuple last = null;
            for (RightTuple current = this.deleteFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            RightTuple rightTuple = tupleSetsImpl.getDeleteFirst();
            last.setStagedNext(rightTuple);
            rightTuple.setStagePrevious(rightTuple);
            this.deleteSize += tupleSetsImpl.deleteSize();
        }
    }

    public void addAllUpdates(RightTupleSets tupleSets) {
        RightTupleSetsImpl tupleSetsImpl = (RightTupleSetsImpl)tupleSets;
        if (this.updateFirst == null) {
            this.updateFirst = tupleSetsImpl.getUpdateFirst();
            this.updateSize = tupleSetsImpl.updateSize;
        } else {
            RightTuple last = null;
            for (RightTuple current = this.updateFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            RightTuple rightTuple = tupleSetsImpl.getUpdateFirst();
            last.setStagedNext(rightTuple);
            rightTuple.setStagePrevious(rightTuple);
            this.updateSize += tupleSetsImpl.updateSize();
        }
    }

    public void addAll(RightTupleSets source) {
        this.addAllInserts(source);
        this.addAllDeletes(source);
        this.addAllUpdates(source);
    }

    public void clear() {
        RightTuple next;
        RightTuple rightTuple = this.getInsertFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        rightTuple = this.getDeleteFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        rightTuple = this.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        this.resetAll();
    }

    @Override
    public RightTupleSets takeAll() {
        RightTupleSetsImpl clone = new RightTupleSetsImpl();
        clone.insertSize = this.insertSize;
        clone.deleteSize = this.deleteSize;
        clone.updateSize = this.updateSize;
        clone.insertFirst = this.insertFirst;
        clone.deleteFirst = this.deleteFirst;
        clone.updateFirst = this.updateFirst;
        this.insertSize = 0;
        this.deleteSize = 0;
        this.updateSize = 0;
        this.insertFirst = null;
        this.deleteFirst = null;
        this.updateFirst = null;
        return clone;
    }

    @Override
    public String toStringSizes() {
        return "TupleSets[insertSize=" + this.insertSize + ", deleteSize=" + this.deleteSize + ", updateSize=" + this.updateSize + "]";
    }

    @Override
    public String toString() {
        RightTuple rightTuple;
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        for (rightTuple = this.getInsertFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(" " + rightTuple + "\n");
        }
        sbuilder.append("Deleted:\n");
        for (rightTuple = this.getDeleteFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(" " + rightTuple + "\n");
        }
        sbuilder.append("Updated:\n");
        for (rightTuple = this.getUpdateFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(" " + rightTuple + "\n");
        }
        return sbuilder.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getInsertFirst() == null && this.getDeleteFirst() == null && this.getUpdateFirst() == null;
    }
}

