/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.kie.api.marshalling.ObjectMarshallingStrategy;

public class OutputMarshaller {
    public static void writeWorkItem(MarshallerWriteContext context, WorkItem workItem) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(workItem.getId());
        stream.writeLong(workItem.getProcessInstanceId());
        stream.writeUTF(workItem.getName());
        stream.writeInt(workItem.getState());
        Map parameters = workItem.getParameters();
        ArrayList notNullValues = new ArrayList();
        for (Object value : parameters.values()) {
            if (value == null) continue;
            notNullValues.add(value);
        }
        stream.writeInt(notNullValues.size());
        for (String key : parameters.keySet()) {
            Object object = parameters.get(key);
            if (object == null) continue;
            stream.writeUTF(key);
            ObjectMarshallingStrategy strategy = context.objectMarshallingStrategyStore.getStrategyObject(object);
            String strategyClassName = strategy.getClass().getName();
            stream.writeInt(-2);
            stream.writeUTF(strategyClassName);
            if (!strategy.accept(object)) continue;
            strategy.write((ObjectOutputStream)stream, object);
        }
    }

    public static void writeTrigger(Trigger trigger, MarshallerWriteContext outCtx) throws IOException {
        if (trigger instanceof CronTrigger) {
            outCtx.writeShort(70);
            CronTrigger cronTrigger = (CronTrigger)trigger;
            outCtx.writeLong(cronTrigger.getStartTime().getTime());
            if (cronTrigger.getEndTime() != null) {
                outCtx.writeBoolean(true);
                outCtx.writeLong(cronTrigger.getEndTime().getTime());
            } else {
                outCtx.writeBoolean(false);
            }
            outCtx.writeInt(cronTrigger.getRepeatLimit());
            outCtx.writeInt(cronTrigger.getRepeatCount());
            outCtx.writeUTF(cronTrigger.getCronEx().getCronExpression());
            if (cronTrigger.getNextFireTime() != null) {
                outCtx.writeBoolean(true);
                outCtx.writeLong(cronTrigger.getNextFireTime().getTime());
            } else {
                outCtx.writeBoolean(false);
            }
            outCtx.writeObject(cronTrigger.getCalendarNames());
        } else if (trigger instanceof IntervalTrigger) {
            outCtx.writeShort(71);
            IntervalTrigger intTrigger = (IntervalTrigger)trigger;
            outCtx.writeLong(intTrigger.getStartTime().getTime());
            if (intTrigger.getEndTime() != null) {
                outCtx.writeBoolean(true);
                outCtx.writeLong(intTrigger.getEndTime().getTime());
            } else {
                outCtx.writeBoolean(false);
            }
            outCtx.writeInt(intTrigger.getRepeatLimit());
            outCtx.writeInt(intTrigger.getRepeatCount());
            if (intTrigger.getNextFireTime() != null) {
                outCtx.writeBoolean(true);
                outCtx.writeLong(intTrigger.getNextFireTime().getTime());
            } else {
                outCtx.writeBoolean(false);
            }
            outCtx.writeLong(intTrigger.getPeriod());
            outCtx.writeObject(intTrigger.getCalendarNames());
        } else if (trigger instanceof PointInTimeTrigger) {
            outCtx.writeShort(72);
            PointInTimeTrigger pinTrigger = (PointInTimeTrigger)trigger;
            outCtx.writeLong(pinTrigger.hasNextFireTime().getTime());
        }
    }
}

