/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.command.CommandService;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJob;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultTimerJobInstance;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobInstance;

public class TrackableTimeJobFactoryManager
implements TimerJobFactoryManager {
    private Map<Long, TimerJobInstance> timerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();

    @Override
    public TimerJobInstance createTimerJobInstance(Job job, JobContext ctx, Trigger trigger, JobHandle handle, InternalSchedulerService scheduler) {
        ctx.setJobHandle(handle);
        DefaultTimerJobInstance jobInstance = new DefaultTimerJobInstance(new SelfRemovalJob(job), new SelfRemovalJobContext(ctx, this.timerInstances), trigger, handle, scheduler);
        return jobInstance;
    }

    @Override
    public void addTimerJobInstance(TimerJobInstance instance) {
        this.timerInstances.put(instance.getJobHandle().getId(), instance);
    }

    @Override
    public void removeTimerJobInstance(TimerJobInstance instance) {
        this.timerInstances.remove(instance.getJobHandle().getId());
    }

    @Override
    public Collection<TimerJobInstance> getTimerJobInstances() {
        return this.timerInstances.values();
    }

    @Override
    public void setCommandService(CommandService commandService) {
    }

    @Override
    public CommandService getCommandService() {
        return null;
    }
}

