/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SingleBenchmark;
import org.optaplanner.benchmark.impl.SolverBenchmark;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.ProblemStatisticType;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.solution.ProblemIO;
import org.optaplanner.persistence.xstream.XStreamProblemIO;

@XStreamAlias(value="problemBenchmarks")
public class ProblemBenchmarksConfig {
    private Class<ProblemIO> problemIOClass = null;
    @XStreamImplicit(itemFieldName="xstreamAnnotatedClass")
    private List<Class> xstreamAnnotatedClassList = null;
    private Boolean writeOutputSolutionEnabled = null;
    @XStreamImplicit(itemFieldName="inputSolutionFile")
    private List<File> inputSolutionFileList = null;
    @XStreamImplicit(itemFieldName="problemStatisticType")
    private List<ProblemStatisticType> problemStatisticTypeList = null;

    public Class<ProblemIO> getProblemIOClass() {
        return this.problemIOClass;
    }

    public void setProblemIOClass(Class<ProblemIO> problemIOClass) {
        this.problemIOClass = problemIOClass;
    }

    public List<Class> getXstreamAnnotatedClassList() {
        return this.xstreamAnnotatedClassList;
    }

    public void setXstreamAnnotatedClassList(List<Class> xstreamAnnotatedClassList) {
        this.xstreamAnnotatedClassList = xstreamAnnotatedClassList;
    }

    public Boolean getWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(Boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public List<File> getInputSolutionFileList() {
        return this.inputSolutionFileList;
    }

    public void setInputSolutionFileList(List<File> inputSolutionFileList) {
        this.inputSolutionFileList = inputSolutionFileList;
    }

    public List<ProblemStatisticType> getProblemStatisticTypeList() {
        return this.problemStatisticTypeList;
    }

    public void setProblemStatisticTypeList(List<ProblemStatisticType> problemStatisticTypeList) {
        this.problemStatisticTypeList = problemStatisticTypeList;
    }

    public List<ProblemBenchmark> buildProblemBenchmarkList(DefaultPlannerBenchmark plannerBenchmark, SolverBenchmark solverBenchmark) {
        this.validate(solverBenchmark);
        ProblemIO problemIO = this.buildProblemIO();
        ArrayList<ProblemBenchmark> problemBenchmarkList = new ArrayList<ProblemBenchmark>(this.inputSolutionFileList.size());
        List<ProblemBenchmark> unifiedProblemBenchmarkList = plannerBenchmark.getUnifiedProblemBenchmarkList();
        for (File inputSolutionFile : this.inputSolutionFileList) {
            ProblemBenchmark problemBenchmark;
            if (!inputSolutionFile.exists()) {
                throw new IllegalArgumentException("The inputSolutionFile (" + inputSolutionFile + ") does not exist.");
            }
            ProblemBenchmark newProblemBenchmark = this.buildProblemBenchmark(plannerBenchmark, problemIO, inputSolutionFile);
            int index = unifiedProblemBenchmarkList.indexOf(newProblemBenchmark);
            if (index < 0) {
                problemBenchmark = newProblemBenchmark;
                unifiedProblemBenchmarkList.add(problemBenchmark);
            } else {
                problemBenchmark = unifiedProblemBenchmarkList.get(index);
            }
            this.addSingleBenchmark(solverBenchmark, problemBenchmark);
            problemBenchmarkList.add(problemBenchmark);
        }
        return problemBenchmarkList;
    }

    private void validate(SolverBenchmark solverBenchmark) {
        if (this.inputSolutionFileList == null || this.inputSolutionFileList.isEmpty()) {
            throw new IllegalArgumentException("Configure at least 1 <inputSolutionFile> for the solverBenchmark (" + solverBenchmark.getName() + ") directly or indirectly by inheriting it.");
        }
    }

    private ProblemIO buildProblemIO() {
        if (this.problemIOClass != null && this.xstreamAnnotatedClassList != null) {
            throw new IllegalArgumentException("Cannot use problemIOClass (" + this.problemIOClass + ") and xstreamAnnotatedClassList (" + this.xstreamAnnotatedClassList + ") together.");
        }
        if (this.problemIOClass != null) {
            return (ProblemIO)ConfigUtils.newInstance((Object)this, (String)"problemIOClass", this.problemIOClass);
        }
        Class[] xstreamAnnotatedClasses = this.xstreamAnnotatedClassList != null ? this.xstreamAnnotatedClassList.toArray(new Class[this.xstreamAnnotatedClassList.size()]) : new Class[]{};
        return new XStreamProblemIO(xstreamAnnotatedClasses);
    }

    private ProblemBenchmark buildProblemBenchmark(DefaultPlannerBenchmark plannerBenchmark, ProblemIO problemIO, File inputSolutionFile) {
        ProblemBenchmark problemBenchmark = new ProblemBenchmark(plannerBenchmark);
        String name = FilenameUtils.getBaseName((String)inputSolutionFile.getName());
        problemBenchmark.setName(name);
        problemBenchmark.setProblemIO(problemIO);
        problemBenchmark.setWriteOutputSolutionEnabled(this.writeOutputSolutionEnabled == null ? false : this.writeOutputSolutionEnabled);
        problemBenchmark.setInputSolutionFile(inputSolutionFile);
        ArrayList<ProblemStatistic> problemStatisticList = new ArrayList<ProblemStatistic>(this.problemStatisticTypeList == null ? 0 : this.problemStatisticTypeList.size());
        if (this.problemStatisticTypeList != null) {
            for (ProblemStatisticType problemStatisticType : this.problemStatisticTypeList) {
                problemStatisticList.add(problemStatisticType.create(problemBenchmark));
            }
        }
        problemBenchmark.setProblemStatisticList(problemStatisticList);
        problemBenchmark.setSingleBenchmarkList(new ArrayList<SingleBenchmark>());
        return problemBenchmark;
    }

    private void addSingleBenchmark(SolverBenchmark solverBenchmark, ProblemBenchmark problemBenchmark) {
        SingleBenchmark singleBenchmark = new SingleBenchmark(solverBenchmark, problemBenchmark);
        solverBenchmark.getSingleBenchmarkList().add(singleBenchmark);
        problemBenchmark.getSingleBenchmarkList().add(singleBenchmark);
    }

    public void inherit(ProblemBenchmarksConfig inheritedConfig) {
        this.problemIOClass = (Class)ConfigUtils.inheritOverwritableProperty(this.problemIOClass, inheritedConfig.getProblemIOClass());
        this.xstreamAnnotatedClassList = ConfigUtils.inheritMergeableListProperty(this.xstreamAnnotatedClassList, inheritedConfig.getXstreamAnnotatedClassList());
        this.writeOutputSolutionEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.writeOutputSolutionEnabled, (Object)inheritedConfig.getWriteOutputSolutionEnabled());
        this.inputSolutionFileList = ConfigUtils.inheritMergeableListProperty(this.inputSolutionFileList, inheritedConfig.getInputSolutionFileList());
        this.problemStatisticTypeList = ConfigUtils.inheritMergeableListProperty(this.problemStatisticTypeList, inheritedConfig.getProblemStatisticTypeList());
    }
}

