/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SingleBenchmark;
import org.optaplanner.benchmark.impl.SolverBenchmark;
import org.optaplanner.core.config.solver.SolverConfig;

@XStreamAlias(value="solverBenchmark")
public class SolverBenchmarkConfig {
    private String name = null;
    @XStreamAlias(value="solver")
    private SolverConfig solverConfig = null;
    @XStreamAlias(value="problemBenchmarks")
    private ProblemBenchmarksConfig problemBenchmarksConfig = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public void setSolverConfig(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public ProblemBenchmarksConfig getProblemBenchmarksConfig() {
        return this.problemBenchmarksConfig;
    }

    public void setProblemBenchmarksConfig(ProblemBenchmarksConfig problemBenchmarksConfig) {
        this.problemBenchmarksConfig = problemBenchmarksConfig;
    }

    public SolverBenchmark buildSolverBenchmark(DefaultPlannerBenchmark plannerBenchmark) {
        this.validate();
        SolverBenchmark solverBenchmark = new SolverBenchmark(plannerBenchmark);
        solverBenchmark.setName(this.name);
        solverBenchmark.setSolverConfig(this.solverConfig);
        solverBenchmark.setSingleBenchmarkList(new ArrayList<SingleBenchmark>());
        ProblemBenchmarksConfig problemBenchmarksConfig_ = this.problemBenchmarksConfig == null ? new ProblemBenchmarksConfig() : this.problemBenchmarksConfig;
        List<ProblemBenchmark> problemBenchmarkList = problemBenchmarksConfig_.buildProblemBenchmarkList(plannerBenchmark, solverBenchmark);
        solverBenchmark.setProblemBenchmarkList(problemBenchmarkList);
        return solverBenchmark;
    }

    private void validate() {
        String nameRegex = "^[\\w\\d _\\-\\.\\(\\)]+$";
        if (!this.name.matches("^[\\w\\d _\\-\\.\\(\\)]+$")) {
            throw new IllegalStateException("The solverBenchmark name (" + this.name + ") is invalid because it does not follow the nameRegex (" + "^[\\w\\d _\\-\\.\\(\\)]+$" + ")" + " which might cause an illegal filename.");
        }
    }

    public void inherit(SolverBenchmarkConfig inheritedConfig) {
        if (this.solverConfig == null) {
            this.solverConfig = inheritedConfig.getSolverConfig();
        } else if (inheritedConfig.getSolverConfig() != null) {
            this.solverConfig.inherit(inheritedConfig.getSolverConfig());
        }
        if (this.problemBenchmarksConfig == null) {
            this.problemBenchmarksConfig = inheritedConfig.getProblemBenchmarksConfig();
        } else if (inheritedConfig.getProblemBenchmarksConfig() != null) {
            this.problemBenchmarksConfig.inherit(inheritedConfig.getProblemBenchmarksConfig());
        }
    }
}

