/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;

public final class BendableScore
extends AbstractScore<BendableScore>
implements FeasibilityScore<BendableScore> {
    private final int[] hardScores;
    private final int[] softScores;

    public static BendableScore parseScore(int hardLevelCount, int softLevelCount, String scoreString) {
        int i;
        int levelCount = hardLevelCount + softLevelCount;
        String[] levelStrings = BendableScore.parseLevelStrings(scoreString, levelCount);
        int[] hardScores = new int[hardLevelCount];
        int[] softScores = new int[softLevelCount];
        for (i = 0; i < hardScores.length; ++i) {
            hardScores[i] = Integer.parseInt(levelStrings[i]);
        }
        for (i = 0; i < softScores.length; ++i) {
            softScores[i] = Integer.parseInt(levelStrings[hardScores.length + i]);
        }
        return BendableScore.valueOf(hardScores, softScores);
    }

    public static BendableScore valueOf(int[] hardScores, int[] softScores) {
        return new BendableScore(hardScores, softScores);
    }

    protected BendableScore(int[] hardScores, int[] softScores) {
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    public int getHardLevelCount() {
        return this.hardScores.length;
    }

    public int getHardScore(int index) {
        return this.hardScores[index];
    }

    public int getSoftLevelCount() {
        return this.softScores.length;
    }

    public int getSoftScore(int index) {
        return this.softScores[index];
    }

    @Override
    public boolean isFeasible() {
        for (int hardScore : this.hardScores) {
            if (hardScore > 0) {
                return true;
            }
            if (hardScore >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public BendableScore add(BendableScore augment) {
        int i;
        this.validateCompatible(augment);
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] + augment.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] + augment.getSoftScore(i);
        }
        return new BendableScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableScore subtract(BendableScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] - subtrahend.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] - subtrahend.getSoftScore(i);
        }
        return new BendableScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableScore multiply(double multiplicand) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor((double)this.hardScores[i] * multiplicand);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor((double)this.softScores[i] * multiplicand);
        }
        return new BendableScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableScore divide(double divisor) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor((double)this.hardScores[i] / divisor);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor((double)this.softScores[i] / divisor);
        }
        return new BendableScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableScore power(double exponent) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor(Math.pow(this.hardScores[i], exponent));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor(Math.pow(this.softScores[i], exponent));
        }
        return new BendableScore(newHardScores, newSoftScores);
    }

    @Override
    public Number[] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BendableScore) {
            int i;
            BendableScore other = (BendableScore)o;
            if (this.getHardLevelCount() != other.getHardLevelCount() || this.getSoftLevelCount() != other.getSoftLevelCount()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i] == other.getHardScore(i)) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i] == other.getSoftScore(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 17;
        for (int hardScore : this.hardScores) {
            hashCode = hashCode * 37 + hardScore;
        }
        for (int softScore : this.softScores) {
            hashCode = hashCode * 37 + softScore;
        }
        return hashCode;
    }

    @Override
    public int compareTo(BendableScore other) {
        int i;
        this.validateCompatible(other);
        for (i = 0; i < this.hardScores.length; ++i) {
            if (this.hardScores[i] == other.getHardScore(i)) continue;
            if (this.hardScores[i] < other.getHardScore(i)) {
                return -1;
            }
            return 1;
        }
        for (i = 0; i < this.softScores.length; ++i) {
            if (this.softScores[i] == other.getSoftScore(i)) continue;
            if (this.softScores[i] < other.getSoftScore(i)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 1);
        boolean first = true;
        for (int hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(hardScore);
        }
        for (int softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(softScore);
        }
        return s.toString();
    }

    public void validateCompatible(BendableScore other) {
        if (this.getHardLevelCount() != other.getHardLevelCount()) {
            throw new IllegalArgumentException("The score (" + this + ") with hardScoreSize (" + this.getHardLevelCount() + ") is not compatible with the other score (" + other + ") with hardScoreSize (" + other.getHardLevelCount() + ").");
        }
        if (this.getSoftLevelCount() != other.getSoftLevelCount()) {
            throw new IllegalArgumentException("The score (" + this + ") with softScoreSize (" + this.getSoftLevelCount() + ") is not compatible with the other score (" + other + ") with softScoreSize (" + other.getSoftLevelCount() + ").");
        }
    }
}

