/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ComparatorSelectionSorter
implements SelectionSorter<Object> {
    private final Comparator<Object> appliedComparator;

    public ComparatorSelectionSorter(Comparator<Object> comparator, SelectionSorterOrder selectionSorterOrder) {
        switch (selectionSorterOrder) {
            case ASCENDING: {
                this.appliedComparator = comparator;
                break;
            }
            case DESCENDING: {
                this.appliedComparator = Collections.reverseOrder(comparator);
                break;
            }
            default: {
                throw new IllegalStateException("The selectionSorterOrder (" + (Object)((Object)selectionSorterOrder) + ") is not implemented.");
            }
        }
    }

    @Override
    public void sort(ScoreDirector scoreDirector, List<Object> selectionList) {
        Collections.sort(selectionList, this.appliedComparator);
    }
}

