/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public abstract class AbstractCachingValueSelector
extends AbstractValueSelector
implements SelectionCacheLifecycleListener {
    protected final EntityIndependentValueSelector childValueSelector;
    protected final SelectionCacheType cacheType;
    protected List<Object> cachedValueList = null;

    public AbstractCachingValueSelector(EntityIndependentValueSelector childValueSelector, SelectionCacheType cacheType) {
        this.childValueSelector = childValueSelector;
        this.cacheType = cacheType;
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a childValueSelector (" + childValueSelector + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(childValueSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    public ValueSelector getChildValueSelector() {
        return this.childValueSelector;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        long childSize = this.childValueSelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a childValueSelector (" + this.childValueSelector + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.cachedValueList = new ArrayList<Object>((int)childSize);
        CollectionUtils.addAll(this.cachedValueList, this.childValueSelector.iterator());
        this.logger.trace("    Created cachedValueList with size ({}) in valueSelector({}).", (Object)this.cachedValueList.size(), (Object)this);
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedValueList = null;
    }

    @Override
    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    public long getSize() {
        return this.cachedValueList.size();
    }
}

