/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.solver.move.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactory;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.solver.move.LectureSwapMove;

public class LectureSwapMoveFactory
implements MoveListFactory {
    @Override
    public List<Move> createMoveList(Solution solution) {
        CourseSchedule schedule = (CourseSchedule)solution;
        List<Lecture> lectureList = schedule.getLectureList();
        ArrayList<Move> moveList = new ArrayList<Move>();
        ListIterator<Lecture> leftIt = lectureList.listIterator();
        while (leftIt.hasNext()) {
            Lecture leftLecture = leftIt.next();
            ListIterator<Lecture> rightIt = lectureList.listIterator(leftIt.nextIndex());
            while (rightIt.hasNext()) {
                Lecture rightLecture = rightIt.next();
                if (leftLecture.getCourse().equals(rightLecture.getCourse())) continue;
                moveList.add(new LectureSwapMove(leftLecture, rightLecture));
            }
        }
        return moveList;
    }
}

