/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed.solver;

import org.apache.commons.lang.ObjectUtils;
import org.optaplanner.core.impl.domain.variable.listener.PlanningVariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;

public class ArrivalTimeUpdatingVariableListener
implements PlanningVariableListener<Customer> {
    @Override
    public void beforeEntityAdded(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector scoreDirector, Customer customer) {
        if (customer instanceof TimeWindowedCustomer) {
            this.updateVehicle(scoreDirector, (TimeWindowedCustomer)customer);
        }
    }

    @Override
    public void beforeVariableChanged(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterVariableChanged(ScoreDirector scoreDirector, Customer customer) {
        if (customer instanceof TimeWindowedCustomer) {
            this.updateVehicle(scoreDirector, (TimeWindowedCustomer)customer);
        }
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector scoreDirector, Customer customer) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector scoreDirector, Customer customer) {
    }

    protected void updateVehicle(ScoreDirector scoreDirector, TimeWindowedCustomer sourceCustomer) {
        TimeWindowedCustomer shadowCustomer;
        Standstill previousStandstill = sourceCustomer.getPreviousStandstill();
        Integer milliDepartureTime = previousStandstill instanceof TimeWindowedCustomer ? ((TimeWindowedCustomer)previousStandstill).getDepartureTime() : null;
        Integer milliArrivalTime = this.calculateMilliArrivalTime(shadowCustomer, milliDepartureTime);
        for (shadowCustomer = sourceCustomer; shadowCustomer != null && ObjectUtils.notEqual((Object)shadowCustomer.getMilliArrivalTime(), (Object)milliArrivalTime); shadowCustomer = shadowCustomer.getNextCustomer()) {
            scoreDirector.beforeVariableChanged(shadowCustomer, "milliArrivalTime");
            shadowCustomer.setMilliArrivalTime(milliArrivalTime);
            scoreDirector.afterVariableChanged(shadowCustomer, "milliArrivalTime");
            milliDepartureTime = shadowCustomer.getDepartureTime();
            milliArrivalTime = this.calculateMilliArrivalTime(shadowCustomer, milliDepartureTime);
        }
    }

    private Integer calculateMilliArrivalTime(TimeWindowedCustomer customer, Integer previousMilliDepartureTime) {
        if (customer == null) {
            return null;
        }
        if (previousMilliDepartureTime == null) {
            return Math.max(customer.getMilliReadyTime(), customer.getMilliDistanceToPreviousStandstill());
        }
        return previousMilliDepartureTime + customer.getMilliDistanceToPreviousStandstill();
    }
}

